/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.State;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.tree.TreeTrunkState;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TreeState
implements State {
    private long creationMillis;
    private BigDecimal energy;
    private List<TreeBranchState> branches;
    private ConditionalTaskState photosynthesis;
    private ConditionalTaskState aging;
    private ConditionalTaskState growth;
    private TreeTrunkState trunkState;
    private float height;
    private Tree3DState tree3DState;

    public TreeState() {
        this.creationMillis = 0L;
        this.energy = new BigDecimal(0);
        this.branches = new ArrayList<TreeBranchState>();
        this.height = 0.0f;
        this.trunkState = new TreeTrunkState();
        this.tree3DState = new Tree3DState();
        this.photosynthesis = new ConditionalTaskState();
        this.aging = new ConditionalTaskState();
        this.growth = new ConditionalTaskState();
    }

    public TreeState(long creationMillis, BigDecimal energy, List<TreeBranchState> branches, ConditionalTaskState photosynthesis, ConditionalTaskState aging, ConditionalTaskState growth, TreeTrunkState trunkState, float height, Tree3DState tree3dState) {
        this.creationMillis = creationMillis;
        this.energy = energy;
        this.branches = branches;
        this.photosynthesis = photosynthesis;
        this.aging = aging;
        this.growth = growth;
        this.trunkState = trunkState;
        this.height = height;
        this.tree3DState = tree3dState;
    }

    public long getCreationMillis() {
        return this.creationMillis;
    }

    public void setCreationMillis(long creationMillis) {
        this.creationMillis = creationMillis;
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public void setEnergy(BigDecimal energy) {
        this.energy = energy;
    }

    public List<TreeBranchState> getBranches() {
        return this.branches;
    }

    public void setBranches(List<TreeBranchState> branches) {
        this.branches = branches;
    }

    public ConditionalTaskState getPhotosynthesis() {
        return this.photosynthesis;
    }

    public void setPhotosynthesis(ConditionalTaskState photosynthesis) {
        this.photosynthesis = photosynthesis;
    }

    public ConditionalTaskState getAging() {
        return this.aging;
    }

    public void setAging(ConditionalTaskState aging) {
        this.aging = aging;
    }

    public ConditionalTaskState getGrowth() {
        return this.growth;
    }

    public void setGrowth(ConditionalTaskState growth) {
        this.growth = growth;
    }

    public TreeTrunkState getTrunkState() {
        return this.trunkState;
    }

    public void setTrunkState(TreeTrunkState trunkState) {
        this.trunkState = trunkState;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public Tree3DState getTree3DState() {
        return this.tree3DState;
    }

    public void setTree3DState(Tree3DState tree3dState) {
        this.tree3DState = tree3dState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branches == null ? 0 : ((Object)this.branches).hashCode());
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + (int)(this.creationMillis ^ this.creationMillis >>> 32);
        result = 31 * result + (this.energy == null ? 0 : this.energy.hashCode());
        result = 31 * result + (this.photosynthesis == null ? 0 : this.photosynthesis.hashCode());
        result = 31 * result + (this.aging == null ? 0 : this.aging.hashCode());
        result = 31 * result + (this.growth == null ? 0 : this.growth.hashCode());
        result = 31 * result + (this.tree3DState == null ? 0 : this.tree3DState.hashCode());
        result = 31 * result + (this.trunkState == null ? 0 : this.trunkState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeState other = (TreeState)obj;
        if (this.branches == null ? other.branches != null : !((Object)this.branches).equals(other.branches)) {
            return false;
        }
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (this.creationMillis != other.creationMillis) {
            return false;
        }
        if (this.energy == null ? other.energy != null : !this.energy.equals(other.energy)) {
            return false;
        }
        if (this.photosynthesis == null ? other.photosynthesis != null : !this.photosynthesis.equals((Object)other.photosynthesis)) {
            return false;
        }
        if (this.aging == null ? other.aging != null : !this.aging.equals((Object)other.aging)) {
            return false;
        }
        if (this.growth == null ? other.growth != null : !this.growth.equals((Object)other.growth)) {
            return false;
        }
        if (this.tree3DState == null ? other.tree3DState != null : !this.tree3DState.equals((Object)other.tree3DState)) {
            return false;
        }
        return !(this.trunkState == null ? other.trunkState != null : !this.trunkState.equals(other.trunkState));
    }

    public String toString() {
        return "TreeState [branches=" + this.branches + ", height=" + this.height + ", creationMillis=" + this.creationMillis + ", energy=" + this.energy + ", photosynthesis=" + this.photosynthesis + ", aging=" + this.aging + ", growth=" + this.growth + ", tree3DState=" + this.tree3DState + ", trunkState=" + this.trunkState + "]";
    }
}

