/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.LivingPart;
import barsuift.simLife.environment.Environment;
import barsuift.simLife.environment.MockEnvironment;
import barsuift.simLife.j3d.universe.MockUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.process.MockSynchronizerCore;
import barsuift.simLife.process.SynchronizerCore;
import barsuift.simLife.time.SimLifeDate;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseState;
import barsuift.simLife.universe.physic.MockPhysics;
import barsuift.simLife.universe.physic.Physics;
import java.util.HashSet;
import java.util.Set;

public class MockUniverse
implements Universe {
    private Set<LivingPart> livingParts;
    private Set<Tree> trees;
    private Set<TreeLeaf> fallenLeaves;
    private long creationMillis;
    private Environment environment;
    private Physics physics;
    private SynchronizerCore synchronizer;
    private SimLifeDate date;
    private Universe3D universe3D;
    private UniverseState state;
    private int synchronizedCalled;

    public MockUniverse() {
        this.reset();
    }

    public void reset() {
        this.livingParts = new HashSet<LivingPart>();
        this.trees = new HashSet<Tree>();
        this.fallenLeaves = new HashSet<TreeLeaf>();
        this.creationMillis = 0L;
        this.environment = new MockEnvironment();
        this.physics = new MockPhysics();
        this.synchronizer = new MockSynchronizerCore();
        this.date = new SimLifeDate();
        this.universe3D = new MockUniverse3D();
        this.state = new UniverseState();
        this.synchronizedCalled = 0;
    }

    public Set<LivingPart> getLivingParts() {
        return this.livingParts;
    }

    public void addLivingPart(LivingPart livingPart) {
        this.livingParts.add(livingPart);
    }

    public void removeLivingPart(LivingPart livingPart) {
        this.livingParts.remove(livingPart);
    }

    public long getCreationMillis() {
        return this.creationMillis;
    }

    public void setCreationMillis(long creationMillis) {
        this.creationMillis = creationMillis;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Physics getPhysics() {
        return this.physics;
    }

    public void setPhysics(Physics physics) {
        this.physics = physics;
    }

    public SynchronizerCore getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(SynchronizerCore synchronizer) {
        this.synchronizer = synchronizer;
    }

    public SimLifeDate getDate() {
        return this.date;
    }

    public void setDate(SimLifeDate date) {
        this.date = date;
    }

    public Set<Tree> getTrees() {
        return this.trees;
    }

    public void addTree(Tree tree) {
        this.trees.add(tree);
    }

    public void removeTree(Tree tree) {
        this.trees.remove(tree);
    }

    public Set<TreeLeaf> getFallenLeaves() {
        return this.fallenLeaves;
    }

    public void addFallenLeaf(TreeLeaf treeLeaf) {
        this.fallenLeaves.add(treeLeaf);
    }

    public void removeFallenLeaf(TreeLeaf treeLeaf) {
        this.fallenLeaves.remove(treeLeaf);
    }

    public Universe3D getUniverse3D() {
        return this.universe3D;
    }

    public void setUniverse3D(Universe3D universe3D) {
        this.universe3D = universe3D;
    }

    public UniverseState getState() {
        return this.state;
    }

    public void setState(UniverseState state) {
        this.state = state;
    }

    public void synchronize() {
        ++this.synchronizedCalled;
    }

    public int getNbSynchronize() {
        return this.synchronizedCalled;
    }
}

