/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.time.FpsCounter;
import junit.framework.TestCase;

public class FpsCounterTest
extends TestCase {
    private FpsCounter counter;

    protected void setUp() throws Exception {
        super.setUp();
        this.counter = new FpsCounter();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.counter = null;
    }

    public void testSingleTick() {
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getExecTime()));
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getAvgExecTime()));
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getFps());
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getAvgFps());
        this.counter.tick();
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getExecTime()));
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getAvgExecTime()));
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getFps());
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getAvgFps());
    }

    public void testSeveralTicks() {
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getExecTime()));
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getAvgExecTime()));
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getFps());
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getAvgFps());
        this.tenTicks();
        FpsCounterTest.assertTrue((String)"just ensure it does not take more than 10 seconds", (this.counter.getExecTime() < 10000.0f ? 1 : 0) != 0);
        FpsCounterTest.assertTrue((String)"the exec time must always be positive", (this.counter.getExecTime() > 0.0f ? 1 : 0) != 0);
        FpsCounterTest.assertEquals((String)"the average time should not have been recomputed", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getAvgExecTime()));
        FpsCounterTest.assertTrue((this.counter.getFps() > 0 ? 1 : 0) != 0);
        FpsCounterTest.assertEquals((String)"the average fps should not have been recomputed", (int)1, (int)this.counter.getAvgFps());
    }

    public void testHundredTicks() {
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getExecTime()));
        FpsCounterTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.counter.getAvgExecTime()));
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getFps());
        FpsCounterTest.assertEquals((int)1, (int)this.counter.getAvgFps());
        for (int i = 0; i < 10; ++i) {
            this.tenTicks();
        }
        FpsCounterTest.assertTrue((String)"just ensure it does not take more than 10 seconds", (this.counter.getExecTime() < 10000.0f ? 1 : 0) != 0);
        FpsCounterTest.assertTrue((String)"the exec time must always be positive", (this.counter.getExecTime() > 0.0f ? 1 : 0) != 0);
        FpsCounterTest.assertTrue((String)"just ensure it does not take more than 10 seconds", (this.counter.getAvgExecTime() < 10000.0f ? 1 : 0) != 0);
        FpsCounterTest.assertTrue((String)"the exec time must always be positive", (this.counter.getAvgExecTime() > 0.0f ? 1 : 0) != 0);
        FpsCounterTest.assertTrue((this.counter.getFps() > 0 ? 1 : 0) != 0);
        FpsCounterTest.assertTrue((this.counter.getAvgFps() > 0 ? 1 : 0) != 0);
    }

    private void tenTicks() {
        for (int i = 0; i < 10; ++i) {
            this.counter.tick();
        }
    }
}

