/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.Speed;
import barsuift.simLife.process.SynchronizerCore;
import barsuift.simLife.process.SynchronizerCoreState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;

public class MockSynchronizerCore
extends BasicPublisher
implements SynchronizerCore {
    private CyclicBarrier barrier;
    private Speed speed;
    private boolean running;
    private int scheduleCalled;
    private List<ConditionalTask> tasksToSchedule;
    private int unscheduleCalled;
    private List<ConditionalTask> tasksToUnschedule;
    private int startCalled;
    private int stopCalled;
    private SynchronizerCoreState state;
    private int synchronizeCalled;
    private int updateCounter;
    private List<Publisher> publisherObjectsSubscribed;
    private List<Object> arguments;

    public MockSynchronizerCore() {
        super(null);
        this.reset();
    }

    public void reset() {
        this.barrier = new CyclicBarrier(1);
        this.speed = Speed.DEFAULT_SPEED;
        this.running = false;
        this.scheduleCalled = 0;
        this.tasksToSchedule = new ArrayList<ConditionalTask>();
        this.unscheduleCalled = 0;
        this.tasksToUnschedule = new ArrayList<ConditionalTask>();
        this.startCalled = 0;
        this.stopCalled = 0;
        this.state = CoreDataCreatorForTests.createSpecificSynchronizerCoreState();
        this.synchronizeCalled = 0;
        this.updateCounter = 0;
        this.publisherObjectsSubscribed = new ArrayList<Publisher>();
        this.arguments = new ArrayList<Object>();
    }

    public void setBarrier(CyclicBarrier barrier) {
        this.barrier = barrier;
    }

    public CyclicBarrier getBarrier() {
        return this.barrier;
    }

    public void setSpeed(Speed speed) {
        this.speed = speed;
    }

    public Speed getSpeed() {
        return this.speed;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void schedule(ConditionalTask task) {
        ++this.scheduleCalled;
        this.tasksToSchedule.add(task);
    }

    public int getNbScheduleCalled() {
        return this.scheduleCalled;
    }

    public List<ConditionalTask> getScheduledTasks() {
        return this.tasksToSchedule;
    }

    public void unschedule(ConditionalTask task) {
        ++this.unscheduleCalled;
        this.tasksToUnschedule.add(task);
    }

    public int getNbUnscheduleCalled() {
        return this.unscheduleCalled;
    }

    public List<ConditionalTask> getUnscheduledTasks() {
        return this.tasksToUnschedule;
    }

    public void start() throws IllegalStateException {
        ++this.startCalled;
    }

    public int getNbStartCalled() {
        return this.startCalled;
    }

    public void stop() {
        ++this.stopCalled;
    }

    public int getNbStopCalled() {
        return this.stopCalled;
    }

    public SynchronizerCoreState getState() {
        return this.state;
    }

    public void setState(SynchronizerCoreState state) {
        this.state = state;
    }

    public void synchronize() {
        ++this.synchronizeCalled;
    }

    public int getNbSynchronizeCalled() {
        return this.synchronizeCalled;
    }

    public void update(Publisher publisher, Object arg) {
        ++this.updateCounter;
        this.publisherObjectsSubscribed.add(publisher);
        this.arguments.add(arg);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public List<Publisher> getPublisherObjectsSubscribed() {
        return this.publisherObjectsSubscribed;
    }

    public int getUpdateCounter() {
        return this.updateCounter;
    }
}

