/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.process.MainSynchronizer;
import barsuift.simLife.process.MainSynchronizerState;
import barsuift.simLife.process.Speed;

public class MockMainSynchronizer
extends BasicPublisher
implements MainSynchronizer {
    private Speed speed;
    private boolean running;
    private int startCalled;
    private int oneStepCalled;
    private int stopCalled;
    private int stopAndWaitCalled;
    private MainSynchronizerState state;
    private int synchronizeCalled;

    public MockMainSynchronizer() {
        super(null);
        this.reset();
    }

    public void reset() {
        this.speed = Speed.DEFAULT_SPEED;
        this.running = false;
        this.startCalled = 0;
        this.oneStepCalled = 0;
        this.stopCalled = 0;
        this.stopAndWaitCalled = 0;
        this.state = CoreDataCreatorForTests.createSpecificMainSynchronizerState();
        this.synchronizeCalled = 0;
    }

    public void setSpeed(Speed speed) {
        this.speed = speed;
    }

    public Speed getSpeed() {
        return this.speed;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void start() throws IllegalStateException {
        ++this.startCalled;
    }

    public int getNbStartCalled() {
        return this.startCalled;
    }

    public void oneStep() {
        ++this.oneStepCalled;
    }

    public int getNbOneStepCalled() {
        return this.oneStepCalled;
    }

    public void stop() {
        ++this.stopCalled;
    }

    public int getNbStopCalled() {
        return this.stopCalled;
    }

    public void stopAndWait() {
        ++this.stopAndWaitCalled;
    }

    public int getNbStopAndWaitCalled() {
        return this.stopAndWaitCalled;
    }

    public MainSynchronizerState getState() {
        return this.state;
    }

    public void setState(MainSynchronizerState state) {
        this.state = state;
    }

    public void synchronize() {
        ++this.synchronizeCalled;
    }

    public int getNbSynchronizeCalled() {
        return this.synchronizeCalled;
    }
}

