/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.Persistent;
import barsuift.simLife.time.TimeCounterState;
import java.text.MessageFormat;
import java.util.Observable;

public class TimeCounter
extends Observable
implements Comparable<TimeCounter>,
Persistent<TimeCounterState> {
    private static final MessageFormat TO_STRING = new MessageFormat("{0} days {1,number,00}:{2,number,00}:{3,number,00}");
    private final TimeCounterState state;
    private int seconds;

    public TimeCounter(TimeCounterState state) {
        if (state.getSeconds() < 0) {
            throw new IllegalArgumentException("The seconds are negative");
        }
        this.state = state;
        this.seconds = state.getSeconds();
    }

    public void increment() {
        ++this.seconds;
        this.setChanged();
        this.notifyObservers();
    }

    public int getSeconds() {
        return this.seconds % 60;
    }

    public int getMinutes() {
        return this.seconds % 3600 / 60;
    }

    public int getHours() {
        return this.seconds % 86400 / 3600;
    }

    public int getDays() {
        return this.seconds / 86400;
    }

    public TimeCounterState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setSeconds(this.seconds);
    }

    public String toString() {
        return TO_STRING.format(new Integer[]{this.getDays(), this.getHours(), this.getMinutes(), this.getSeconds()});
    }

    @Override
    public int compareTo(TimeCounter o) {
        return this.seconds - o.seconds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.seconds;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeCounter other = (TimeCounter)obj;
        return this.seconds == other.seconds;
    }
}

