/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.time.ObservableTestHelper;
import barsuift.simLife.time.TimeCounter;
import barsuift.simLife.time.TimeCounterState;
import barsuift.simLife.time.TimeCounterTestHelper;
import java.util.Observable;
import junit.framework.TestCase;

public class TimeCounterTest
extends TestCase {
    private ObservableTestHelper observerHelper;

    protected void setUp() throws Exception {
        super.setUp();
        this.observerHelper = new ObservableTestHelper();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.observerHelper = null;
    }

    public void testIncrement() {
        int i;
        TimeCounter counter = new TimeCounter(new TimeCounterState());
        TimeCounterTestHelper.assertEquals(0, 0, 0, 0, counter);
        counter.increment();
        TimeCounterTestHelper.assertEquals(0, 0, 0, 1, counter);
        for (i = 0; i < 58; ++i) {
            counter.increment();
        }
        TimeCounterTestHelper.assertEquals(0, 0, 0, 59, counter);
        counter.increment();
        TimeCounterTestHelper.assertEquals(0, 0, 1, 0, counter);
        counter.increment();
        TimeCounterTestHelper.assertEquals(0, 0, 1, 1, counter);
        for (i = 0; i < 59; ++i) {
            counter.increment();
        }
        TimeCounterTestHelper.assertEquals(0, 0, 2, 0, counter);
        for (i = 0; i < 3480; ++i) {
            counter.increment();
        }
        TimeCounterTestHelper.assertEquals(0, 1, 0, 0, counter);
        for (i = 0; i < 82800; ++i) {
            counter.increment();
        }
        TimeCounterTestHelper.assertEquals(1, 0, 0, 0, counter);
    }

    public void testObserver() {
        TimeCounter counter = new TimeCounter(new TimeCounterState());
        this.observerHelper.addObserver((Observable)counter);
        TimeCounterTestHelper.assertEquals(0, 0, 0, 0, counter);
        counter.increment();
        TimeCounterTestHelper.assertEquals(0, 0, 0, 1, counter);
        TimeCounterTest.assertEquals((int)1, (int)this.observerHelper.nbUpdated());
        TimeCounterTest.assertEquals(null, (Object)this.observerHelper.getUpdateObjects().get(0));
    }

    public void testToString() {
        int i;
        TimeCounter counter = new TimeCounter(new TimeCounterState());
        TimeCounterTest.assertEquals((String)"0 days 00:00:00", (String)counter.toString());
        counter.increment();
        TimeCounterTest.assertEquals((String)"0 days 00:00:01", (String)counter.toString());
        for (i = 0; i < 59; ++i) {
            counter.increment();
        }
        TimeCounterTest.assertEquals((String)"0 days 00:01:00", (String)counter.toString());
        for (i = 0; i < 3540; ++i) {
            counter.increment();
        }
        TimeCounterTest.assertEquals((String)"0 days 01:00:00", (String)counter.toString());
        for (i = 0; i < 803; ++i) {
            counter.increment();
        }
        TimeCounterTest.assertEquals((String)"0 days 01:13:23", (String)counter.toString());
        for (i = 0; i < 126000; ++i) {
            counter.increment();
        }
        TimeCounterTest.assertEquals((String)"1 days 12:13:23", (String)counter.toString());
    }

    public void testConstructors() {
        try {
            new TimeCounter((TimeCounterState)null);
            TimeCounterTest.fail((String)"Should throw an NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new TimeCounter(new TimeCounterState(-1));
            TimeCounterTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCompareTo() {
        TimeCounter counter1 = new TimeCounter(new TimeCounterState(0));
        TimeCounter counter2 = new TimeCounter(new TimeCounterState(0));
        TimeCounter counter3 = new TimeCounter(new TimeCounterState(12));
        TimeCounter counter4 = new TimeCounter(new TimeCounterState(0));
        for (int i = 0; i < 12; ++i) {
            counter4.increment();
        }
        TimeCounterTest.assertEquals((int)0, (int)counter1.compareTo(counter1));
        TimeCounterTest.assertEquals((int)0, (int)counter1.compareTo(counter2));
        TimeCounterTest.assertEquals((int)0, (int)counter2.compareTo(counter1));
        TimeCounterTest.assertEquals((int)0, (int)counter2.compareTo(counter2));
        TimeCounterTest.assertEquals((int)0, (int)counter3.compareTo(counter3));
        TimeCounterTest.assertEquals((int)0, (int)counter3.compareTo(counter4));
        TimeCounterTest.assertEquals((int)0, (int)counter4.compareTo(counter3));
        TimeCounterTest.assertEquals((int)0, (int)counter4.compareTo(counter4));
        TimeCounterTest.assertEquals((int)-12, (int)counter1.compareTo(counter3));
        TimeCounterTest.assertEquals((int)12, (int)counter3.compareTo(counter1));
    }

    public void testGetState() {
        TimeCounterState state = new TimeCounterState(47);
        TimeCounter counter = new TimeCounter(state);
        TimeCounterTest.assertEquals((Object)state, (Object)counter.getState());
    }
}

