/**
 * barsuift-simlife is a life simulator programm
 * 
 * Copyright (C) 2010 Cyrille GACHOT
 * 
 * This file is part of barsuift-simlife.
 * 
 * barsuift-simlife is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * barsuift-simlife is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with barsuift-simlife. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package barsuift.simLife.time;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TimeCounterState {

    private int seconds;

    public TimeCounterState() {
        this.seconds = 0;
    }

    public TimeCounterState(int seconds) {
        this.seconds = seconds;
    }

    public TimeCounterState(TimeCounterState copy) {
        this.seconds = copy.seconds;
    }

    public int getSeconds() {
        return seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + seconds;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        TimeCounterState other = (TimeCounterState) obj;
        if (seconds != other.seconds)
            return false;
        return true;
    }

    @Override
    public String toString() {
        return "TimeCounterState [seconds=" + seconds + "]";
    }

}
