/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.time;

import barsuift.simLife.time.TimeCounter;
import barsuift.simLife.time.TimeMessenger;
import barsuift.simLife.universe.Universe;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class UniverseTimeController {
    private final ScheduledExecutorService scheduledThreadPool;
    private ScheduledFuture<?> runningProcess;
    private final TimeMessenger timeMessenger;
    private boolean running;

    public UniverseTimeController(Universe universe) {
        int poolSize = 1;
        this.scheduledThreadPool = Executors.newScheduledThreadPool(poolSize);
        this.timeMessenger = new TimeMessenger(universe);
        this.running = false;
    }

    public void start() throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("The controller is already running");
        }
        this.running = true;
        int initialDelay = 0;
        long period = 1L;
        this.runningProcess = this.scheduledThreadPool.scheduleAtFixedRate(this.timeMessenger, initialDelay, period, TimeUnit.SECONDS);
    }

    public void oneStep() {
        if (this.running) {
            throw new IllegalStateException("The controller is already running");
        }
        this.timeMessenger.run();
    }

    public void pause() {
        if (!this.running) {
            throw new IllegalStateException("The controller is not running");
        }
        this.running = false;
        this.runningProcess.cancel(false);
    }

    public boolean isRunning() {
        return this.running;
    }

    public TimeCounter getTimeCounter() {
        return this.timeMessenger.getTimeCounter();
    }
}

