/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe.physic;

import barsuift.simLife.j3d.Mobile;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.universe.physic.BasicGravity3D;
import barsuift.simLife.j3d.universe.physic.Gravity3D;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.tree.BasicTreeLeaf;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.physic.Gravity;
import barsuift.simLife.universe.physic.GravityState;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BasicGravity
implements Gravity {
    private final GravityState state;
    private final Gravity3D gravity3D;
    private final Set<TreeLeaf> fallingLeaves;
    private final Universe universe;

    public BasicGravity(GravityState state, Universe universe) {
        this.state = state;
        this.universe = universe;
        this.fallingLeaves = new HashSet<TreeLeaf>();
        this.gravity3D = new BasicGravity3D(state.getGravity3D(), universe.getUniverse3D());
        Set fallingLeafStates = state.getFallingLeaves();
        for (TreeLeafState fallingLeafState : fallingLeafStates) {
            this.addFallingLeaf(new BasicTreeLeaf(universe, fallingLeafState));
        }
    }

    public Set<TreeLeaf> getFallingLeaves() {
        return Collections.unmodifiableSet(this.fallingLeaves);
    }

    public void addFallingLeaf(TreeLeaf treeLeaf) {
        treeLeaf.addSubscriber((Subscriber)this);
        this.fallingLeaves.add(treeLeaf);
        this.gravity3D.fall((Mobile)treeLeaf.getTreeLeaf3D());
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == MobileEvent.FALLEN) {
            TreeLeaf leaf = (TreeLeaf)publisher;
            this.fallingLeaves.remove(leaf);
            this.gravity3D.isFallen((Mobile)leaf.getTreeLeaf3D());
            this.universe.addFallenLeaf(leaf);
        }
    }

    public GravityState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        HashSet<TreeLeafState> fallingLeaveStates = new HashSet<TreeLeafState>();
        for (TreeLeaf leaf : this.fallingLeaves) {
            fallingLeaveStates.add((TreeLeafState)leaf.getState());
        }
        this.state.setFallingLeaves(fallingLeaveStates);
        this.gravity3D.synchronize();
    }

    public Gravity3D getGravity3D() {
        return this.gravity3D;
    }
}

