/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.LivingPart;
import barsuift.simLife.environment.BasicEnvironment;
import barsuift.simLife.environment.Environment;
import barsuift.simLife.j3d.universe.BasicUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.process.BasicSynchronizerCore;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.ConditionalTaskStateFactory;
import barsuift.simLife.process.DateUpdater;
import barsuift.simLife.process.SynchronizerCore;
import barsuift.simLife.time.DateHandler;
import barsuift.simLife.time.SimLifeDate;
import barsuift.simLife.tree.BasicTree;
import barsuift.simLife.tree.BasicTreeLeaf;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseState;
import barsuift.simLife.universe.physic.BasicPhysics;
import barsuift.simLife.universe.physic.Physics;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.Node;

public class BasicUniverse
implements Universe {
    private final UniverseState state;
    private final Set<Tree> trees;
    private final Set<TreeLeaf> fallenLeaves;
    private final Environment environment;
    private final Physics physics;
    private final BasicSynchronizerCore synchronizer;
    private final DateHandler dateHandler;
    private final BasicUniverse3D universe3D;

    public BasicUniverse(UniverseState state) {
        this.state = state;
        this.universe3D = new BasicUniverse3D(state.getUniv3DState(), (Universe)this);
        this.environment = new BasicEnvironment(state.getEnvironment());
        this.physics = new BasicPhysics(this, state.getPhysics());
        this.synchronizer = new BasicSynchronizerCore(state.getSynchronizerState());
        this.dateHandler = new DateHandler(state.getDateHandler());
        ConditionalTaskStateFactory taskStateFactory = new ConditionalTaskStateFactory();
        ConditionalTaskState dateUpdaterState = taskStateFactory.createConditionalTaskState(DateUpdater.class);
        DateUpdater dateUpdater = new DateUpdater(dateUpdaterState, this.dateHandler.getDate());
        this.synchronizer.schedule((ConditionalTask)dateUpdater);
        this.trees = new HashSet<Tree>();
        Set treeStates = state.getTrees();
        for (TreeState treeState : treeStates) {
            BasicTree newTree = new BasicTree(this, treeState);
            this.trees.add(newTree);
            System.out.println("nb Leaves=" + newTree.getNbLeaves());
        }
        this.fallenLeaves = new HashSet<TreeLeaf>();
        Set fallenLeafStates = state.getFallenLeaves();
        for (TreeLeafState fallenLeafState : fallenLeafStates) {
            this.fallenLeaves.add(new BasicTreeLeaf(this, fallenLeafState));
        }
        this.universe3D.initFromUniverse((Universe)this);
    }

    public Set<LivingPart> getLivingParts() {
        HashSet<Tree> livingParts = new HashSet<Tree>();
        livingParts.addAll(this.trees);
        return Collections.unmodifiableSet(livingParts);
    }

    public Set<Tree> getTrees() {
        return Collections.unmodifiableSet(this.trees);
    }

    public void addTree(Tree tree) {
        this.trees.add(tree);
        this.universe3D.addElement3D((Node)tree.getTree3D().getBranchGroup());
    }

    public Set<TreeLeaf> getFallenLeaves() {
        return Collections.unmodifiableSet(this.fallenLeaves);
    }

    public void addFallenLeaf(TreeLeaf treeLeaf) {
        this.fallenLeaves.add(treeLeaf);
        this.universe3D.addElement3D((Node)treeLeaf.getTreeLeaf3D().getBranchGroup());
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Physics getPhysics() {
        return this.physics;
    }

    public SynchronizerCore getSynchronizer() {
        return this.synchronizer;
    }

    public SimLifeDate getDate() {
        return this.dateHandler.getDate();
    }

    public UniverseState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        HashSet<TreeState> treeStates = new HashSet<TreeState>();
        for (Tree tree : this.trees) {
            treeStates.add((TreeState)tree.getState());
        }
        this.state.setTrees(treeStates);
        HashSet<TreeLeafState> fallenLeaveStates = new HashSet<TreeLeafState>();
        for (TreeLeaf leaf : this.fallenLeaves) {
            fallenLeaveStates.add((TreeLeafState)leaf.getState());
        }
        this.state.setFallenLeaves(fallenLeaveStates);
        this.environment.synchronize();
        this.physics.synchronize();
        this.synchronizer.synchronize();
        this.dateHandler.synchronize();
        this.universe3D.synchronize();
    }

    public Universe3D getUniverse3D() {
        return this.universe3D;
    }
}

