/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.Tree3DState;
import barsuift.simLife.j3d.tree.Tree3DStateFactory;
import barsuift.simLife.process.Aging;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.ConditionalTaskStateFactory;
import barsuift.simLife.process.Photosynthesis;
import barsuift.simLife.process.TreeGrowth;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.tree.TreeBranchStateFactory;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.tree.TreeTrunkState;
import barsuift.simLife.tree.TreeTrunkStateFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class TreeStateFactory {
    public static final int HEIGHT_RADIUS_RATIO = 8;
    public static final float HEIGHT_BRANCH_RADIAL_LENGTH_RATIO = 0.5f;

    public TreeState createRandomTreeState(Point3d translationVector) {
        int creationMillis = Randomizer.randomBetween((int)0, (int)100) * 1000;
        BigDecimal energy = new BigDecimal(Randomizer.randomBetween((int)0, (int)100));
        int nbBranches = Randomizer.randomBetween((int)30, (int)50);
        float height = Randomizer.randomBetween((int)3, (int)5);
        float radius = height / 8.0f;
        ArrayList<TreeBranchState> branches = new ArrayList<TreeBranchState>(nbBranches);
        for (int i = 0; i < nbBranches; ++i) {
            branches.add(this.computeRandomBranchState(radius, height));
        }
        ConditionalTaskStateFactory taskStateFactory = new ConditionalTaskStateFactory();
        ConditionalTaskState photosynthesis = taskStateFactory.createConditionalTaskState(Photosynthesis.class);
        ConditionalTaskState aging = taskStateFactory.createConditionalTaskState(Aging.class);
        ConditionalTaskState growth = taskStateFactory.createConditionalTaskState(TreeGrowth.class);
        TreeTrunkStateFactory trunkStateFactory = new TreeTrunkStateFactory();
        TreeTrunkState trunkState = trunkStateFactory.createRandomTreeTrunkState(radius, height);
        Tree3DStateFactory tree3DStateFactory = new Tree3DStateFactory();
        Tree3DState tree3dState = tree3DStateFactory.createRandomTree3DState(new Tuple3dState((Tuple3d)translationVector));
        return new TreeState((long)creationMillis, energy, branches, photosynthesis, aging, growth, trunkState, height, tree3dState);
    }

    protected TreeBranchState computeRandomBranchState(float treeRadius, float treeHeight) {
        Vector3d branchTranslationVector = this.computeBranchTranslationVector(treeRadius, treeHeight);
        Point3d branchEndPoint = this.computeBranchEndPoint(treeHeight, branchTranslationVector.getX() > 0.0, branchTranslationVector.getZ() > 0.0);
        TreeBranchStateFactory branchStateFactory = new TreeBranchStateFactory();
        return branchStateFactory.createRandomBranchState(branchTranslationVector, branchEndPoint);
    }

    protected Vector3d computeBranchTranslationVector(float treeRadius, float treeHeight) {
        double translationXShift = Randomizer.random3();
        double translationZShift = Randomizer.random3() * Math.sin(Math.acos(translationXShift));
        double translationX = translationXShift * (double)treeRadius;
        double translationZ = translationZShift * (double)treeRadius;
        Vector3d translationVector = new Vector3d(translationX, (double)treeHeight, translationZ);
        return translationVector;
    }

    protected Point3d computeBranchEndPoint(double treeHeight, boolean goingToPositiveX, boolean goingToPositiveZ) {
        double xMove = Math.random() * 0.5 * treeHeight;
        if (!goingToPositiveX) {
            xMove = -xMove;
        }
        double yMove = Math.random() * treeHeight;
        double zMove = Math.random() * 0.5 * treeHeight;
        if (!goingToPositiveZ) {
            zMove = -zMove;
        }
        Point3d endPoint = new Point3d(xMove, yMove, zMove);
        return endPoint;
    }
}

