/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.tree.TreeBranch3DState;
import barsuift.simLife.j3d.tree.TreeBranch3DStateFactory;
import barsuift.simLife.j3d.util.BarycentreHelper;
import barsuift.simLife.j3d.util.PointHelper;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeBranchPartStateFactory;
import barsuift.simLife.tree.TreeBranchState;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class TreeBranchStateFactory {
    public TreeBranchState createRandomBranchState(Vector3d translationVector, Point3d branchEndPoint) {
        int creationMillis = Randomizer.randomBetween((int)0, (int)100) * 1000;
        BigDecimal energy = new BigDecimal(Randomizer.randomBetween((int)0, (int)100));
        BigDecimal freeEnergy = new BigDecimal(Randomizer.randomBetween((int)0, (int)50));
        TreeBranchPartStateFactory treeBranchPartStateFactory = new TreeBranchPartStateFactory();
        ArrayList<TreeBranchPartState> treeBranchPartStates = new ArrayList<TreeBranchPartState>();
        int nbParts = 3;
        for (int i = 0; i < nbParts; ++i) {
            Point3d branchPartEndPoint = this.computeBranchPartEndPoint(branchEndPoint, nbParts);
            treeBranchPartStates.add(treeBranchPartStateFactory.createRandomBranchPartState(branchPartEndPoint));
        }
        TreeBranch3DStateFactory branch3DStateFactory = new TreeBranch3DStateFactory();
        TreeBranch3DState branch3DState = branch3DStateFactory.createRandomTreeBranch3DState(translationVector);
        return new TreeBranchState((long)creationMillis, energy, freeEnergy, treeBranchPartStates, branch3DState);
    }

    protected Point3d computeBranchPartEndPoint(Point3d branchEndPoint, int nbParts) {
        Point3d startPoint = new Point3d(0.0, 0.0, 0.0);
        double maxDistance = startPoint.distance(branchEndPoint);
        double averagePartLength = maxDistance / (double)nbParts;
        Point3d partEndPoint = BarycentreHelper.getBarycentre((Point3d)new Point3d(0.0, 0.0, 0.0), (Point3d)branchEndPoint, (double)((Randomizer.random2() + 1.0) * averagePartLength));
        partEndPoint = PointHelper.shiftPoint((Point3d)partEndPoint, (double)(maxDistance / 10.0));
        return partEndPoint;
    }
}

