/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.Axis;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeBranchPart3DStateFactory;
import barsuift.simLife.j3d.util.BarycentreHelper;
import barsuift.simLife.j3d.util.DistanceHelper;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeLeafStateFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class TreeBranchPartStateFactory {
    public TreeBranchPartState createRandomBranchPartState(Point3d branchPartEndPoint) {
        int creationMillis = Randomizer.randomBetween((int)0, (int)100) * 1000;
        BigDecimal energy = new BigDecimal(Randomizer.randomBetween((int)0, (int)100));
        BigDecimal freeEnergy = new BigDecimal(Randomizer.randomBetween((int)0, (int)50));
        TreeLeafStateFactory leafStateFactory = new TreeLeafStateFactory();
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>();
        int nbLeaves = Randomizer.randomBetween((int)2, (int)4);
        double maxDistance = DistanceHelper.distanceFromOrigin((Point3d)branchPartEndPoint);
        double shift = maxDistance / (double)nbLeaves;
        for (int index = 0; index < nbLeaves; ++index) {
            Point3d leafAttachPoint = BarycentreHelper.getBarycentre((Point3d)new Point3d(0.0, 0.0, 0.0), (Point3d)branchPartEndPoint, (double)(((double)index + Randomizer.random2()) * shift));
            double rotation = Randomizer.randomRotation();
            Transform3D transform = TransformerHelper.getTranslationTransform3D((Vector3d)new Vector3d((Tuple3d)leafAttachPoint));
            Transform3D rotationT3D = TransformerHelper.getRotationTransform3D((double)rotation, (Axis)Axis.Y);
            transform.mul(rotationT3D);
            leaveStates.add(leafStateFactory.createRandomTreeLeafState(transform));
        }
        TreeBranchPart3DStateFactory branchPart3DStateFactory = new TreeBranchPart3DStateFactory();
        TreeBranchPart3DState branch3DState = branchPart3DStateFactory.createRandomTreeBranchPart3DState(new Tuple3dState((Tuple3d)branchPartEndPoint));
        return new TreeBranchPartState((long)creationMillis, energy, freeEnergy, leaveStates, branch3DState);
    }
}

