/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.tree.BasicTreeTrunk3D;
import barsuift.simLife.j3d.tree.TreeTrunk3D;
import barsuift.simLife.tree.TreeTrunk;
import barsuift.simLife.tree.TreeTrunkState;
import barsuift.simLife.universe.Universe;

public class BasicTreeTrunk
implements TreeTrunk {
    private final TreeTrunkState state;
    private final long creationMillis;
    private float radius;
    private float height;
    private final TreeTrunk3D trunk3D;

    public BasicTreeTrunk(Universe universe, TreeTrunkState state) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (state == null) {
            throw new IllegalArgumentException("null trunk state");
        }
        this.state = state;
        this.creationMillis = state.getCreationMillis();
        this.radius = state.getRadius();
        this.height = state.getHeight();
        this.trunk3D = new BasicTreeTrunk3D(universe.getUniverse3D(), state.getTrunk3DState(), (TreeTrunk)this);
    }

    public float getHeight() {
        return this.height;
    }

    public float getRadius() {
        return this.radius;
    }

    public TreeTrunkState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setHeight(this.height);
        this.state.setRadius(this.radius);
        this.trunk3D.synchronize();
    }

    public long getCreationMillis() {
        return this.creationMillis;
    }

    public void age() {
    }

    public TreeTrunk3D getTreeTrunk3D() {
        return this.trunk3D;
    }
}

