/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.tree.BasicTreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.tree.LeafEvent;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BasicTreeLeaf
implements TreeLeaf {
    private static final BigDecimal ONE = new BigDecimal(1);
    private static final BigDecimal AGING_EFFICIENCY_DECREASE = PercentHelper.getDecimalValue((int)95);
    private static final BigDecimal LOWEST_EFFICIENCY_BEFORE_FALLING = PercentHelper.getDecimalValue((int)10);
    private static final BigDecimal ENERGY_RATIO_TO_KEEP = PercentHelper.getDecimalValue((int)66);
    private static final BigDecimal MAX_ENERGY = new BigDecimal(100);
    private final TreeLeafState state;
    private BigDecimal efficiency;
    private final long creationMillis;
    private BigDecimal energy;
    private BigDecimal freeEnergy;
    private final TreeLeaf3D leaf3D;
    private final Universe universe;
    private final Publisher publisher = new BasicPublisher((Publisher)this);

    public BasicTreeLeaf(Universe universe, TreeLeafState leafState) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (leafState == null) {
            throw new IllegalArgumentException("null leaf state");
        }
        this.state = leafState;
        this.efficiency = this.state.getEfficiency();
        this.creationMillis = this.state.getCreationMillis();
        this.energy = this.state.getEnergy();
        this.freeEnergy = this.state.getFreeEnergy();
        this.universe = universe;
        this.leaf3D = new BasicTreeLeaf3D(universe.getUniverse3D(), leafState.getLeaf3DState(), (TreeLeaf)this);
        this.leaf3D.addSubscriber((Subscriber)this);
    }

    public void age() {
        this.efficiency = this.efficiency.multiply(AGING_EFFICIENCY_DECREASE);
        this.setChanged();
        this.notifySubscribers(LeafEvent.EFFICIENCY);
        if (this.isTooWeak()) {
            this.fall();
        }
    }

    public void collectSolarEnergy() {
        BigDecimal lightRate = this.universe.getEnvironment().getSun().getBrightness();
        BigDecimal solarEnergyRateCollected = this.efficiency.multiply(lightRate);
        BigDecimal energyCollected = solarEnergyRateCollected.multiply(Sun.ENERGY_DENSITY).multiply(new BigDecimal(this.leaf3D.getArea()));
        BigDecimal energyCollectedForLeaf = energyCollected.multiply(ENERGY_RATIO_TO_KEEP);
        BigDecimal freeEnergyCollected = energyCollected.subtract(energyCollectedForLeaf);
        this.energy = this.energy.add(energyCollectedForLeaf).setScale(10, RoundingMode.HALF_DOWN);
        this.energy = this.energy.min(MAX_ENERGY);
        this.freeEnergy = this.freeEnergy.add(freeEnergyCollected).setScale(5, RoundingMode.HALF_DOWN);
    }

    public boolean isTooWeak() {
        return this.efficiency.compareTo(LOWEST_EFFICIENCY_BEFORE_FALLING) < 0;
    }

    private void fall() {
        this.setChanged();
        this.notifySubscribers(MobileEvent.FALLING);
        this.universe.getPhysics().getGravity().addFallingLeaf((TreeLeaf)this);
    }

    public void improveEfficiency() {
        BigDecimal maxEfficiencyToAdd = ONE.subtract(this.efficiency);
        BigDecimal efficiencyToAdd = maxEfficiencyToAdd.min(this.energy.movePointLeft(2));
        this.efficiency = this.efficiency.add(efficiencyToAdd).setScale(10, RoundingMode.HALF_DOWN);
        this.energy = this.energy.subtract(efficiencyToAdd.movePointRight(2)).setScale(5, RoundingMode.HALF_DOWN);
        this.setChanged();
        this.notifySubscribers(LeafEvent.EFFICIENCY);
    }

    public BigDecimal getEfficiency() {
        return this.efficiency;
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public BigDecimal collectFreeEnergy() {
        BigDecimal currentFreeEnergy = this.freeEnergy;
        this.freeEnergy = new BigDecimal(0);
        return currentFreeEnergy;
    }

    public long getCreationMillis() {
        return this.creationMillis;
    }

    public TreeLeaf3D getTreeLeaf3D() {
        return this.leaf3D;
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == MobileEvent.FALLEN) {
            this.setChanged();
            this.notifySubscribers(arg);
        }
    }

    public TreeLeafState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setEfficiency(this.efficiency);
        this.state.setEnergy(this.energy);
        this.state.setFreeEnergy(this.freeEnergy);
        this.leaf3D.synchronize();
    }

    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    public void setChanged() {
        this.publisher.setChanged();
    }

    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

