/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.Axis;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.tree.BasicTreeBranchPart3D;
import barsuift.simLife.j3d.tree.TreeBranchPart3D;
import barsuift.simLife.j3d.util.TransformerHelper;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.tree.BasicTreeLeaf;
import barsuift.simLife.tree.TreeBranchPart;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafComparator;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeLeafStateFactory;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BasicTreeBranchPart
implements TreeBranchPart {
    private static final int MAX_NB_LEAVES = 4;
    private static final BigDecimal MAX_ENERGY = new BigDecimal(200);
    private static final BigDecimal NEW_LEAF_CREATION_COST = new BigDecimal(40);
    private static final BigDecimal NEW_LEAF_ENERGY_PROVIDED = new BigDecimal(50);
    private static final BigDecimal INCREASE_LEAF_COST = new BigDecimal(20);
    private static final BigDecimal ENERGY_RATIO_TO_KEEP = PercentHelper.getDecimalValue((int)50);
    private final TreeBranchPartState state;
    private final long creationMillis;
    private BigDecimal energy;
    private BigDecimal freeEnergy;
    private final ConcurrentLinkedQueue<TreeLeaf> leaves;
    private final TreeBranchPart3D branchPart3D;
    private final Universe universe;

    public BasicTreeBranchPart(Universe universe, TreeBranchPartState state) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (state == null) {
            throw new IllegalArgumentException("null branch part state");
        }
        this.universe = universe;
        this.state = state;
        this.creationMillis = state.getCreationMillis();
        this.energy = state.getEnergy();
        this.freeEnergy = state.getFreeEnergy();
        List leaveStates = state.getLeaveStates();
        this.leaves = new ConcurrentLinkedQueue();
        for (TreeLeafState treeLeafState : leaveStates) {
            BasicTreeLeaf leaf = new BasicTreeLeaf(universe, treeLeafState);
            leaf.addSubscriber((Subscriber)this);
            this.leaves.add(leaf);
        }
        this.branchPart3D = new BasicTreeBranchPart3D(universe.getUniverse3D(), state.getBranchPart3DState(), (TreeBranchPart)this);
    }

    public long getCreationMillis() {
        return this.creationMillis;
    }

    public void age() {
        for (TreeLeaf leaf : this.leaves) {
            leaf.age();
        }
    }

    public void grow() {
        if (this.shouldCreateOneNewLeaf() && this.canCreateOneNewLeaf()) {
            this.createOneNewLeaf();
        }
        if (this.shouldIncreaseOneLeafSize() && this.canIncreaseOneLeafSize()) {
            this.increaseOneLeafSize();
        }
    }

    protected void increaseOneLeafSize() {
        TreeLeaf leaf = this.getRandomLeafToIncrease();
        leaf.getTreeLeaf3D().increaseSize();
        this.energy = this.energy.subtract(INCREASE_LEAF_COST);
    }

    protected TreeLeaf getRandomLeafToIncrease() {
        ArrayList<TreeLeaf> leavesToIncrease = new ArrayList<TreeLeaf>(this.leaves.size());
        for (TreeLeaf leaf : this.leaves) {
            if (leaf.getTreeLeaf3D().isMaxSizeReached()) continue;
            leavesToIncrease.add(leaf);
        }
        if (leavesToIncrease.size() == 0) {
            return null;
        }
        if (leavesToIncrease.size() == 1) {
            return (TreeLeaf)leavesToIncrease.get(0);
        }
        HashMap<TreeLeaf, Double> areas = new HashMap<TreeLeaf, Double>(leavesToIncrease.size());
        for (TreeLeaf leaf : leavesToIncrease) {
            areas.put(leaf, leaf.getTreeLeaf3D().getArea());
        }
        double sumArea = 0.0;
        for (Double area : areas.values()) {
            sumArea += area.doubleValue();
        }
        double sumDiffArea = (double)(leavesToIncrease.size() - 1) * sumArea;
        HashMap ratios = new HashMap(areas.size());
        for (Map.Entry entry : areas.entrySet()) {
            ratios.put(entry.getKey(), (sumArea - (Double)entry.getValue()) / sumDiffArea);
        }
        double random = Math.random();
        double previousMinBound = 0.0;
        for (Map.Entry entry : ratios.entrySet()) {
            TreeLeaf leaf = (TreeLeaf)entry.getKey();
            Double ratio = (Double)entry.getValue();
            if (random < previousMinBound + ratio) {
                return leaf;
            }
            previousMinBound += ratio.doubleValue();
        }
        return null;
    }

    protected boolean canIncreaseOneLeafSize() {
        if (this.energy.compareTo(INCREASE_LEAF_COST) < 0) {
            return false;
        }
        return this.hasAtLeastOneLeafToIncrease();
    }

    private boolean hasAtLeastOneLeafToIncrease() {
        for (TreeLeaf leaf : this.leaves) {
            if (leaf.getTreeLeaf3D().isMaxSizeReached()) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldIncreaseOneLeafSize() {
        BigDecimal increaseLength;
        if (this.energy.compareTo(INCREASE_LEAF_COST) <= 0) {
            return false;
        }
        BigDecimal maxBound = INCREASE_LEAF_COST.multiply(new BigDecimal(5));
        if (this.energy.compareTo(maxBound) >= 0) {
            return true;
        }
        BigDecimal remainingEnergy = this.energy.subtract(INCREASE_LEAF_COST);
        BigDecimal ratio = remainingEnergy.divide(increaseLength = maxBound.subtract(INCREASE_LEAF_COST), 4, RoundingMode.HALF_UP);
        return ratio.compareTo(new BigDecimal(Math.random())) >= 0;
    }

    protected boolean canCreateOneNewLeaf() {
        if (this.getNbLeaves() >= 4) {
            return false;
        }
        return this.energy.compareTo(NEW_LEAF_CREATION_COST.add(NEW_LEAF_ENERGY_PROVIDED)) >= 0;
    }

    protected boolean shouldCreateOneNewLeaf() {
        BigDecimal totalCostOfLeafCreation = NEW_LEAF_CREATION_COST.add(NEW_LEAF_ENERGY_PROVIDED);
        if (this.energy.compareTo(totalCostOfLeafCreation) <= 0) {
            return false;
        }
        if (this.energy.compareTo(totalCostOfLeafCreation.multiply(new BigDecimal(2))) >= 0) {
            return true;
        }
        BigDecimal remainingEnergy = this.energy.subtract(totalCostOfLeafCreation);
        BigDecimal ratio = remainingEnergy.divide(totalCostOfLeafCreation, 4, RoundingMode.HALF_UP);
        return ratio.compareTo(new BigDecimal(Math.random())) >= 0;
    }

    protected void createOneNewLeaf() {
        Transform3D transform = this.computeTransformForNewLeaf();
        TreeLeafStateFactory treeLeafStateFactory = new TreeLeafStateFactory();
        TreeLeafState treeLeafState = treeLeafStateFactory.createNewTreeLeafState(transform, NEW_LEAF_ENERGY_PROVIDED, this.universe.getDate().getTimeInMillis());
        BasicTreeLeaf leaf = new BasicTreeLeaf(this.universe, treeLeafState);
        leaf.addSubscriber((Subscriber)this);
        this.leaves.add(leaf);
        this.branchPart3D.addLeaf(leaf.getTreeLeaf3D());
        BigDecimal totalLeafCreationCost = NEW_LEAF_CREATION_COST.add(NEW_LEAF_ENERGY_PROVIDED);
        this.energy = this.energy.subtract(totalLeafCreationCost);
    }

    private Transform3D computeTransformForNewLeaf() {
        Point3d leafAttachPoint = this.computeAttachPointForNewLeaf();
        double rotation = Randomizer.randomRotation();
        Transform3D transform = TransformerHelper.getTranslationTransform3D((Vector3d)new Vector3d((Tuple3d)leafAttachPoint));
        Transform3D rotationT3D = TransformerHelper.getRotationTransform3D((double)rotation, (Axis)Axis.Y);
        transform.mul(rotationT3D);
        return transform;
    }

    protected Point3d computeAttachPointForNewLeaf() {
        double distance;
        Point3d previousAttachPoint = new Point3d(0.0, 0.0, 0.0);
        Point3d saveAttachPoint1 = null;
        Point3d saveAttachPoint2 = null;
        double maxDistance = -1.0;
        ArrayList<TreeLeaf> sortedLeaves = new ArrayList<TreeLeaf>(this.leaves);
        Collections.sort(sortedLeaves, new TreeLeafComparator());
        for (TreeLeaf leaf : sortedLeaves) {
            Point3d attachPoint = leaf.getTreeLeaf3D().getPosition();
            distance = previousAttachPoint.distance(attachPoint);
            if (distance > maxDistance) {
                maxDistance = distance;
                saveAttachPoint1 = previousAttachPoint;
                saveAttachPoint2 = attachPoint;
            }
            previousAttachPoint = attachPoint;
        }
        Point3d attachPoint = this.branchPart3D.getEndPoint();
        distance = previousAttachPoint.distance(attachPoint);
        if (distance > maxDistance) {
            maxDistance = distance;
            saveAttachPoint1 = previousAttachPoint;
            saveAttachPoint2 = attachPoint;
        }
        Point3d newLeafAttachPoint = new Point3d();
        newLeafAttachPoint.interpolate((Tuple3d)saveAttachPoint1, (Tuple3d)saveAttachPoint2, 0.5 + Randomizer.random1());
        return newLeafAttachPoint;
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public BigDecimal collectFreeEnergy() {
        BigDecimal currentFreeEnergy = this.freeEnergy;
        this.freeEnergy = new BigDecimal(0);
        return currentFreeEnergy;
    }

    public void collectSolarEnergy() {
        BigDecimal freeEnergyCollectedFromLeaf = new BigDecimal(0);
        for (TreeLeaf leaf : this.leaves) {
            leaf.collectSolarEnergy();
            freeEnergyCollectedFromLeaf = freeEnergyCollectedFromLeaf.add(leaf.collectFreeEnergy());
        }
        BigDecimal energyCollectedForBranchPart = freeEnergyCollectedFromLeaf.multiply(ENERGY_RATIO_TO_KEEP);
        BigDecimal freeEnergyCollected = freeEnergyCollectedFromLeaf.subtract(energyCollectedForBranchPart);
        this.energy = this.energy.add(energyCollectedForBranchPart);
        this.energy = this.energy.min(MAX_ENERGY);
        this.freeEnergy = this.freeEnergy.add(freeEnergyCollected);
    }

    public int getNbLeaves() {
        return this.leaves.size();
    }

    public Collection<TreeLeaf> getLeaves() {
        return Collections.unmodifiableCollection(this.leaves);
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == MobileEvent.FALLING) {
            TreeLeaf leaf = (TreeLeaf)publisher;
            this.leaves.remove(leaf);
        }
    }

    public TreeBranchPartState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setEnergy(this.energy);
        this.state.setFreeEnergy(this.freeEnergy);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>();
        for (TreeLeaf leaf : this.leaves) {
            leaveStates.add((TreeLeafState)leaf.getState());
        }
        this.state.setLeaveStates(leaveStates);
        this.branchPart3D.synchronize();
    }

    public TreeBranchPart3D getBranchPart3D() {
        return this.branchPart3D;
    }
}

