/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.process.AbstractTaskSynchronizer;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.Speed;
import barsuift.simLife.process.SynchronizerCore;
import barsuift.simLife.process.SynchronizerCoreState;

public class BasicSynchronizerCore
extends AbstractTaskSynchronizer<ConditionalTask>
implements SynchronizerCore {
    private final SynchronizerCoreState state;
    private Speed speed;

    public BasicSynchronizerCore(SynchronizerCoreState state) {
        this.state = state;
        this.speed = state.getSpeed();
    }

    public void setSpeed(Speed speed) {
        this.speed = speed;
    }

    public Speed getSpeed() {
        return this.speed;
    }

    protected int getTemporizerPeriod() {
        return 500 / this.speed.getSpeed();
    }

    public SynchronizerCoreState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setSpeed(this.speed);
    }

    protected Runnable createBarrierTask() {
        return new BarrierTask();
    }

    private class BarrierTask
    implements Runnable {
        private BarrierTask() {
        }

        @Override
        public synchronized void run() {
            BasicSynchronizerCore.this.updateTaskList(true);
            BasicSynchronizerCore.this.synchronizeWithOthers();
            if (BasicSynchronizerCore.this.isStopAsked()) {
                BasicSynchronizerCore.this.internalStop();
            }
        }
    }
}

