/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.process.BasicSynchronizer3D;
import barsuift.simLife.process.BasicSynchronizerCore;
import barsuift.simLife.process.MainSynchronizer;
import barsuift.simLife.process.MainSynchronizerState;
import barsuift.simLife.process.Speed;
import barsuift.simLife.process.Synchronizer3D;
import barsuift.simLife.process.SynchronizerCore;
import barsuift.simLife.universe.Universe;
import java.util.concurrent.CyclicBarrier;

public class BasicMainSynchronizer
implements MainSynchronizer,
Subscriber {
    private final MainSynchronizerState state;
    private boolean isStopAsked;
    private CyclicBarrier barrier;
    private final SynchronizerCore synchroCore;
    private final Synchronizer3D synchro3D;
    private final Publisher publisher = new BasicPublisher((Publisher)this);
    private boolean notifiedFromCore;
    private boolean notifiedFrom3D;

    public BasicMainSynchronizer(MainSynchronizerState state, Universe universe) {
        this.state = state;
        this.isStopAsked = false;
        this.barrier = new CyclicBarrier(2, new BarrierTask());
        this.synchroCore = universe.getSynchronizer();
        this.synchroCore.addSubscriber((Subscriber)this);
        this.synchroCore.setBarrier(this.barrier);
        this.synchro3D = universe.getUniverse3D().getSynchronizer();
        this.synchro3D.addSubscriber((Subscriber)this);
        this.synchro3D.setBarrier(this.barrier);
    }

    public void setSpeed(Speed speed) {
        this.synchroCore.setSpeed(speed);
        this.synchro3D.setStepSize(speed.getSpeed());
    }

    public Speed getSpeed() {
        return this.synchroCore.getSpeed();
    }

    public boolean isRunning() {
        return this.synchroCore.isRunning() || this.synchro3D.isRunning();
    }

    public synchronized void oneStep() {
        this.isStopAsked = true;
        this.internalStart();
    }

    public synchronized void start() {
        this.isStopAsked = false;
        this.internalStart();
    }

    private void internalStart() {
        if (this.isRunning()) {
            throw new IllegalStateException("The synchronizer is already running");
        }
        this.synchroCore.start();
        this.synchro3D.start();
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("The synchronizer is not running");
        }
        this.isStopAsked = true;
    }

    private void internalStop() {
        if (!this.isRunning()) {
            throw new IllegalStateException("The synchronizer is not running");
        }
        this.synchroCore.stop();
        this.synchro3D.stop();
    }

    public synchronized void stopAndWait() {
        this.stop();
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    public MainSynchronizerState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
    }

    public void update(Publisher publisher, Object arg) {
        if (publisher instanceof BasicSynchronizer3D) {
            this.notifiedFrom3D = true;
        }
        if (publisher instanceof BasicSynchronizerCore) {
            this.notifiedFromCore = true;
        }
        if (this.notifiedFrom3D && this.notifiedFromCore) {
            this.notifiedFrom3D = false;
            this.notifiedFromCore = false;
            this.setChanged();
            this.notifySubscribers();
        }
    }

    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    public void setChanged() {
        this.publisher.setChanged();
    }

    public void clearChanged() {
        this.publisher.clearChanged();
    }

    private class BarrierTask
    implements Runnable {
        private BarrierTask() {
        }

        @Override
        public synchronized void run() {
            if (BasicMainSynchronizer.this.isStopAsked) {
                BasicMainSynchronizer.this.internalStop();
            }
        }
    }
}

