/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.environment;

import barsuift.simLife.environment.Sun;
import barsuift.simLife.environment.SunState;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.j3d.environment.BasicSun3D;
import barsuift.simLife.j3d.environment.Sun3D;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import java.math.BigDecimal;

public class BasicSun
implements Sun {
    private final SunState state;
    private BigDecimal brightness;
    private BigDecimal riseAngle;
    private BigDecimal zenithAngle;
    private final Sun3D sun3D;
    private final Publisher publisher = new BasicPublisher((Publisher)this);

    public BasicSun(SunState state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("Null sun state");
        }
        this.state = state;
        this.brightness = state.getBrightness();
        this.riseAngle = state.getRiseAngle();
        this.zenithAngle = state.getZenithAngle();
        this.sun3D = new BasicSun3D((Sun)this);
    }

    public BigDecimal getBrightness() {
        return this.brightness;
    }

    public void setBrightness(BigDecimal brightness) throws IllegalArgumentException {
        if (brightness == null) {
            throw new IllegalArgumentException("Sun brightness can not be null");
        }
        if (!this.brightness.equals(brightness)) {
            this.brightness = brightness;
            this.setChanged();
            this.notifySubscribers(SunUpdateCode.brightness);
        }
    }

    public BigDecimal getRiseAngle() {
        return this.riseAngle;
    }

    public void setRiseAngle(BigDecimal riseAngle) {
        if (riseAngle == null) {
            throw new IllegalArgumentException("Sun rise angle can not be null");
        }
        if (!this.riseAngle.equals(riseAngle)) {
            this.riseAngle = riseAngle;
            this.setChanged();
            this.notifySubscribers(SunUpdateCode.riseAngle);
        }
    }

    public BigDecimal getZenithAngle() {
        return this.zenithAngle;
    }

    public void setZenithAngle(BigDecimal zenithAngle) {
        if (zenithAngle == null) {
            throw new IllegalArgumentException("Sun zenith angle can not be null");
        }
        if (!this.zenithAngle.equals(zenithAngle)) {
            this.zenithAngle = zenithAngle;
            this.setChanged();
            this.notifySubscribers(SunUpdateCode.zenithAngle);
        }
    }

    public SunState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setBrightness(this.brightness);
        this.state.setRiseAngle(this.riseAngle);
        this.state.setZenithAngle(this.zenithAngle);
    }

    public Sun3D getSun3D() {
        return this.sun3D;
    }

    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    public void setChanged() {
        this.publisher.setChanged();
    }

    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

