/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe.physic;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.tree.LeafEvent;
import barsuift.simLife.tree.MockTreeLeaf;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.BasicUniverse;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseState;
import barsuift.simLife.universe.UniverseStateFactory;
import barsuift.simLife.universe.physic.BasicGravity;
import barsuift.simLife.universe.physic.GravityState;
import barsuift.simLife.universe.physic.GravityStateFactory;
import java.util.HashSet;
import junit.framework.TestCase;

public class BasicGravityTest
extends TestCase {
    private BasicUniverse universe;
    private GravityState gravityState;

    protected void setUp() throws Exception {
        super.setUp();
        UniverseStateFactory universeStateFactory = new UniverseStateFactory();
        UniverseState universeState = universeStateFactory.createRandomUniverseState();
        this.universe = new BasicUniverse(universeState);
        GravityStateFactory gravityStateFactory = new GravityStateFactory();
        this.gravityState = gravityStateFactory.createGravityState();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.universe = null;
        this.gravityState = null;
    }

    public void testAddFallingLeaf() {
        HashSet<TreeLeafState> fallingLeaves = new HashSet<TreeLeafState>();
        fallingLeaves.add(CoreDataCreatorForTests.createRandomTreeLeafState());
        fallingLeaves.add(CoreDataCreatorForTests.createRandomTreeLeafState());
        this.gravityState.setFallingLeaves(fallingLeaves);
        BasicGravity gravity = new BasicGravity(this.gravityState, (Universe)this.universe);
        BasicGravityTest.assertEquals((int)2, (int)gravity.getFallingLeaves().size());
        BasicGravityTest.assertEquals((int)2, (int)gravity.getGravity3D().getGroup().numChildren());
        for (TreeLeaf treeLeaf : gravity.getFallingLeaves()) {
            TreeLeaf3D treeLeaf3D = treeLeaf.getTreeLeaf3D();
            BasicGravityTest.assertEquals((int)2, (int)treeLeaf.countSubscribers());
            BasicGravityTest.assertEquals((int)1, (int)treeLeaf3D.countSubscribers());
            treeLeaf.deleteSubscriber((Subscriber)gravity);
            BasicGravityTest.assertEquals((int)1, (int)treeLeaf.countSubscribers());
            treeLeaf.deleteSubscriber((Subscriber)treeLeaf3D);
            BasicGravityTest.assertEquals((int)0, (int)treeLeaf.countSubscribers());
            treeLeaf3D.deleteSubscriber((Subscriber)treeLeaf);
            BasicGravityTest.assertEquals((int)0, (int)treeLeaf3D.countSubscribers());
        }
        MockTreeLeaf treeLeaf = new MockTreeLeaf();
        gravity.addFallingLeaf((TreeLeaf)treeLeaf);
        BasicGravityTest.assertEquals((int)3, (int)gravity.getFallingLeaves().size());
        BasicGravityTest.assertEquals((int)3, (int)gravity.getGravity3D().getGroup().numChildren());
        BasicGravityTest.assertEquals((int)1, (int)treeLeaf.countSubscribers());
        treeLeaf.deleteSubscriber((Subscriber)gravity);
        BasicGravityTest.assertEquals((int)0, (int)treeLeaf.countSubscribers());
    }

    public void testUpdate() {
        BasicGravity gravity = new BasicGravity(this.gravityState, (Universe)this.universe);
        MockTreeLeaf treeLeaf = new MockTreeLeaf();
        gravity.addFallingLeaf((TreeLeaf)treeLeaf);
        BasicGravityTest.assertTrue((boolean)gravity.getFallingLeaves().contains(treeLeaf));
        BasicGravityTest.assertFalse((boolean)this.universe.getFallenLeaves().contains(treeLeaf));
        BasicGravityTest.assertEquals((int)1, (int)gravity.getGravity3D().getGroup().numChildren());
        gravity.update((Publisher)treeLeaf, (Object)MobileEvent.FALLING);
        BasicGravityTest.assertTrue((boolean)gravity.getFallingLeaves().contains(treeLeaf));
        BasicGravityTest.assertFalse((boolean)this.universe.getFallenLeaves().contains(treeLeaf));
        BasicGravityTest.assertEquals((int)1, (int)gravity.getGravity3D().getGroup().numChildren());
        gravity.update((Publisher)treeLeaf, null);
        BasicGravityTest.assertTrue((boolean)gravity.getFallingLeaves().contains(treeLeaf));
        BasicGravityTest.assertFalse((boolean)this.universe.getFallenLeaves().contains(treeLeaf));
        BasicGravityTest.assertEquals((int)1, (int)gravity.getGravity3D().getGroup().numChildren());
        gravity.update((Publisher)treeLeaf, (Object)LeafEvent.EFFICIENCY);
        BasicGravityTest.assertTrue((boolean)gravity.getFallingLeaves().contains(treeLeaf));
        BasicGravityTest.assertFalse((boolean)this.universe.getFallenLeaves().contains(treeLeaf));
        BasicGravityTest.assertEquals((int)1, (int)gravity.getGravity3D().getGroup().numChildren());
        gravity.update((Publisher)treeLeaf, (Object)MobileEvent.FALLEN);
        BasicGravityTest.assertFalse((boolean)gravity.getFallingLeaves().contains(treeLeaf));
        BasicGravityTest.assertTrue((boolean)this.universe.getFallenLeaves().contains(treeLeaf));
        BasicGravityTest.assertEquals((int)0, (int)gravity.getGravity3D().getGroup().numChildren());
    }

    public void testGetState() {
        BasicGravity gravity = new BasicGravity(this.gravityState, (Universe)this.universe);
        BasicGravityTest.assertEquals((Object)this.gravityState, (Object)gravity.getState());
        BasicGravityTest.assertSame((Object)this.gravityState, (Object)gravity.getState());
        BasicGravityTest.assertEquals((int)0, (int)gravity.getState().getFallingLeaves().size());
        gravity.addFallingLeaf((TreeLeaf)new MockTreeLeaf());
        BasicGravityTest.assertEquals((Object)this.gravityState, (Object)gravity.getState());
        BasicGravityTest.assertSame((Object)this.gravityState, (Object)gravity.getState());
        BasicGravityTest.assertEquals((int)1, (int)gravity.getState().getFallingLeaves().size());
    }
}

