/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.FileTestHelper;
import barsuift.simLife.universe.BasicUniverseContextFactory;
import barsuift.simLife.universe.UniverseContext;
import barsuift.simLife.universe.UniverseContextIO;
import java.io.File;
import junit.framework.TestCase;

public class UniverseContextIOTest
extends TestCase {
    private UniverseContextIO universeIo;
    private File file;

    protected void setUp() throws Exception {
        super.setUp();
        this.file = new File("target/test-data/simlife.xml");
        FileTestHelper.deleteAllFiles((File)this.file.getParentFile());
        this.universeIo = new UniverseContextIO(this.file);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.universeIo = null;
        FileTestHelper.deleteAllFiles((File)this.file.getParentFile());
        this.file = null;
    }

    public void testWriteAndReadRandom() throws Exception {
        BasicUniverseContextFactory factory = new BasicUniverseContextFactory();
        UniverseContext universeContext = factory.createRandom();
        this.universeIo.write(universeContext);
        UniverseContext universeContext2 = this.universeIo.read();
        UniverseContextIOTest.assertEquals((Object)universeContext.getState(), (Object)universeContext2.getState());
    }

    public void testWriteAndReadEmpty() throws Exception {
        BasicUniverseContextFactory factory = new BasicUniverseContextFactory();
        UniverseContext universeContext = factory.createEmpty();
        this.universeIo.write(universeContext);
        UniverseContext universeContext2 = this.universeIo.read();
        UniverseContextIOTest.assertEquals((Object)universeContext.getState(), (Object)universeContext2.getState());
    }
}

