/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeLeafStateFactory;
import java.math.BigDecimal;
import javax.media.j3d.Transform3D;
import junit.framework.TestCase;

public class TreeLeafStateFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateRandomTreeLeafState() {
        TreeLeafStateFactory factory = new TreeLeafStateFactory();
        TreeLeafState treeLeafState = factory.createRandomTreeLeafState(new Transform3D());
        TreeLeafStateFactoryTest.assertNotNull((Object)treeLeafState);
        TreeLeafStateFactoryTest.assertNotNull((Object)treeLeafState.getLeaf3DState());
        TreeLeafStateFactoryTest.assertTrue((PercentHelper.getDecimalValue((int)90).compareTo(treeLeafState.getEfficiency()) <= 0 ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((PercentHelper.getDecimalValue((int)100).compareTo(treeLeafState.getEfficiency()) >= 0 ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((treeLeafState.getCreationMillis() >= 0L ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((treeLeafState.getCreationMillis() <= 100000L ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((treeLeafState.getEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((treeLeafState.getEnergy().compareTo(new BigDecimal(100)) <= 0 ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((treeLeafState.getFreeEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((treeLeafState.getFreeEnergy().compareTo(new BigDecimal(50)) <= 0 ? 1 : 0) != 0);
    }

    public void testCreateNewTreeLeafState() {
        TreeLeafStateFactory factory = new TreeLeafStateFactory();
        BigDecimal energy = new BigDecimal(30);
        long creationMillis = 200L;
        TreeLeafState treeLeafState = factory.createNewTreeLeafState(new Transform3D(), energy, creationMillis);
        TreeLeafStateFactoryTest.assertNotNull((Object)treeLeafState);
        TreeLeafStateFactoryTest.assertEquals((long)creationMillis, (long)treeLeafState.getCreationMillis());
        TreeLeaf3DState leaf3dState = treeLeafState.getLeaf3DState();
        TreeLeafStateFactoryTest.assertNotNull((Object)leaf3dState);
        TreeLeafStateFactoryTest.assertEquals((Object)leaf3dState.getInitialEndPoint1(), (Object)leaf3dState.getEndPoint1());
        TreeLeafStateFactoryTest.assertEquals((Object)leaf3dState.getInitialEndPoint2(), (Object)leaf3dState.getEndPoint2());
        TreeLeafStateFactoryTest.assertTrue((PercentHelper.getDecimalValue((int)90).compareTo(treeLeafState.getEfficiency()) <= 0 ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertTrue((PercentHelper.getDecimalValue((int)100).compareTo(treeLeafState.getEfficiency()) >= 0 ? 1 : 0) != 0);
        TreeLeafStateFactoryTest.assertEquals((Object)energy, (Object)treeLeafState.getEnergy());
        TreeLeafStateFactoryTest.assertEquals((Object)new BigDecimal(0), (Object)treeLeafState.getFreeEnergy());
    }
}

