/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.Transform3DState;
import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeBranchPartStateFactory;
import barsuift.simLife.tree.TreeLeafState;
import java.math.BigDecimal;
import java.util.List;
import javax.vecmath.Point3d;
import junit.framework.TestCase;

public class TreeBranchPartStateFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateRandomBranchPartState() {
        TreeBranchPartStateFactory factory = new TreeBranchPartStateFactory();
        Point3d branchPartEndPoint = new Point3d(Math.random(), Math.random(), Math.random());
        TreeBranchPartState branchPartState = factory.createRandomBranchPartState(branchPartEndPoint);
        TreeBranchPartStateFactoryTest.assertNotNull((Object)branchPartState.getBranchPart3DState());
        List leaveStates = branchPartState.getLeaveStates();
        int nbLeaves = leaveStates.size();
        TreeBranchPartStateFactoryTest.assertTrue((nbLeaves >= 2 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((nbLeaves <= 4 ? 1 : 0) != 0);
        for (int index = 0; index < nbLeaves; ++index) {
            TreeLeafState leafState = (TreeLeafState)leaveStates.get(index);
            Transform3DState transform = leafState.getLeaf3DState().getTransform();
            Point3d leafAttachPoint = new Point3d(transform.getMatrix()[3], transform.getMatrix()[7], transform.getMatrix()[11]);
            PointTestHelper.assertPointIsWithinBounds((Point3d)leafAttachPoint, (Point3d)new Point3d(0.0, 0.0, 0.0), (Point3d)branchPartEndPoint);
        }
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getCreationMillis() >= 0L ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getCreationMillis() <= 100000L ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getEnergy().compareTo(new BigDecimal(100)) <= 0 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getFreeEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getFreeEnergy().compareTo(new BigDecimal(50)) <= 0 ? 1 : 0) != 0);
    }
}

