/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.MockSun;
import barsuift.simLife.process.Aging;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.MockSynchronizerCore;
import barsuift.simLife.process.Photosynthesis;
import barsuift.simLife.process.TreeGrowth;
import barsuift.simLife.tree.BasicTree;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import junit.framework.TestCase;

public class BasicTreeTest
extends TestCase {
    private MockUniverse universe;
    private TreeState treeState;
    private BasicTree tree;

    protected void setUp() throws Exception {
        super.setUp();
        this.universe = new MockUniverse();
        this.treeState = CoreDataCreatorForTests.createSpecificTreeState();
        this.tree = new BasicTree((Universe)this.universe, this.treeState);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.universe = null;
        this.treeState = null;
        this.tree = null;
    }

    public void testBasicTree() {
        BasicTreeTest.assertEquals((int)this.treeState.getBranches().size(), (int)this.tree.getNbBranches());
        try {
            new BasicTree(null, this.treeState);
            BasicTreeTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTree((Universe)this.universe, null);
            BasicTreeTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        MockSynchronizerCore synchronizer = (MockSynchronizerCore)this.universe.getSynchronizer();
        BasicTreeTest.assertEquals((int)3, (int)synchronizer.getNbScheduleCalled());
        BasicTreeTest.assertEquals((int)3, (int)synchronizer.getScheduledTasks().size());
        BasicTreeTest.assertEquals(Photosynthesis.class, ((ConditionalTask)synchronizer.getScheduledTasks().get(0)).getClass());
        BasicTreeTest.assertEquals(Aging.class, ((ConditionalTask)synchronizer.getScheduledTasks().get(1)).getClass());
        BasicTreeTest.assertEquals(TreeGrowth.class, ((ConditionalTask)synchronizer.getScheduledTasks().get(2)).getClass());
    }

    public void testGetState() {
        BasicTreeTest.assertEquals((Object)this.treeState, (Object)this.tree.getState());
        BasicTreeTest.assertSame((Object)this.treeState, (Object)this.tree.getState());
        BigDecimal energy = this.tree.getState().getEnergy();
        this.tree.collectSolarEnergy();
        BasicTreeTest.assertEquals((Object)this.treeState, (Object)this.tree.getState());
        BasicTreeTest.assertSame((Object)this.treeState, (Object)this.tree.getState());
        BasicTreeTest.assertFalse((boolean)energy.equals(this.tree.getState().getEnergy()));
    }

    public void testCollectSolarEnergy() {
        ((MockSun)this.universe.getEnvironment().getSun()).setBrightness(PercentHelper.getDecimalValue((int)70));
        this.tree.collectSolarEnergy();
        BasicTreeTest.assertEquals((int)40, (int)this.tree.getNbBranches());
        BasicTreeTest.assertEquals((double)2075.44, (double)this.tree.getEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeTest.assertEquals((double)0.0, (double)this.tree.collectFreeEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeTest.assertEquals((Object)new BigDecimal(0), (Object)this.tree.collectFreeEnergy());
    }
}

