/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.Environment;
import barsuift.simLife.environment.MockEnvironment;
import barsuift.simLife.environment.MockSun;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.j3d.MobileEvent;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.tree.BasicTreeLeaf;
import barsuift.simLife.tree.LeafEvent;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import junit.framework.TestCase;

public class BasicTreeLeafTest
extends TestCase {
    private BasicTreeLeaf leaf;
    private PublisherTestHelper publisherHelper;
    private MockUniverse universe;
    private TreeLeafState leafState;
    private MockSun mockSun;

    protected void setUp() throws Exception {
        super.setUp();
        this.leafState = CoreDataCreatorForTests.createSpecificTreeLeafState();
        BigDecimal lightRate = PercentHelper.getDecimalValue((int)70);
        this.mockSun = new MockSun();
        this.mockSun.setBrightness(lightRate);
        MockEnvironment mockEnv = new MockEnvironment();
        mockEnv.setSun((Sun)this.mockSun);
        this.universe = new MockUniverse();
        this.universe.setEnvironment((Environment)mockEnv);
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.publisherHelper = new PublisherTestHelper();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.mockSun = null;
        this.leaf = null;
        this.publisherHelper = null;
        this.universe = null;
        this.leafState = null;
    }

    public void testBasicTreeLeaf() {
        try {
            new BasicTreeLeaf(null, this.leafState);
            BasicTreeLeafTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeLeaf((Universe)this.universe, null);
            BasicTreeLeafTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCollectSolarEnergy() {
        this.leaf.collectSolarEnergy();
        BasicTreeLeafTest.assertEquals((double)0.8, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((double)14.43520013, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((double)5.2848, (double)this.leaf.collectFreeEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((Object)new BigDecimal(0), (Object)this.leaf.collectFreeEnergy());
        this.leafState.setEnergy(new BigDecimal("99"));
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.leaf.collectSolarEnergy();
        BasicTreeLeafTest.assertEquals((double)100.0, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
    }

    public void testAge() {
        this.publisherHelper.addSubscriberTo((Publisher)this.leaf);
        BasicTreeLeafTest.assertEquals((int)0, (int)this.publisherHelper.nbUpdated());
        BasicTreeLeafTest.assertEquals((double)0.8, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        this.leaf.age();
        BasicTreeLeafTest.assertEquals((double)0.76, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((int)1, (int)this.publisherHelper.nbUpdated());
        Object updateParam = this.publisherHelper.getUpdateObjects().get(0);
        BasicTreeLeafTest.assertEquals((Object)LeafEvent.EFFICIENCY, updateParam);
    }

    public void testImproveEfficiency() {
        this.publisherHelper.addSubscriberTo((Publisher)this.leaf);
        BasicTreeLeafTest.assertEquals((double)0.8, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((double)10.0, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
        this.leaf.improveEfficiency();
        BasicTreeLeafTest.assertEquals((double)0.9, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((double)0.0, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
        this.leafState.setEnergy(new BigDecimal("35"));
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.leaf.improveEfficiency();
        BasicTreeLeafTest.assertEquals((double)1.0, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((double)15.0, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
    }

    public void testFall() {
        this.leafState.setEfficiency(PercentHelper.getDecimalValue((int)10));
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.publisherHelper.addSubscriberTo((Publisher)this.leaf);
        BasicTreeLeafTest.assertFalse((boolean)this.leaf.isTooWeak());
        BasicTreeLeafTest.assertEquals((int)0, (int)this.universe.getPhysics().getGravity().getFallingLeaves().size());
        this.leaf.age();
        BasicTreeLeafTest.assertTrue((this.leaf.getEfficiency().doubleValue() < 0.1 ? 1 : 0) != 0);
        BasicTreeLeafTest.assertTrue((boolean)this.leaf.isTooWeak());
        BasicTreeLeafTest.assertEquals((int)2, (int)this.publisherHelper.nbUpdated());
        Object updateParam1 = this.publisherHelper.getUpdateObjects().get(0);
        BasicTreeLeafTest.assertEquals((Object)LeafEvent.EFFICIENCY, updateParam1);
        Object updateParam2 = this.publisherHelper.getUpdateObjects().get(1);
        BasicTreeLeafTest.assertEquals((Object)MobileEvent.FALLING, updateParam2);
        BasicTreeLeafTest.assertEquals((int)1, (int)this.universe.getPhysics().getGravity().getFallingLeaves().size());
        BasicTreeLeafTest.assertTrue((boolean)this.universe.getPhysics().getGravity().getFallingLeaves().contains(this.leaf));
    }

    public void testUpdate() {
        TreeLeaf3D leaf3D = this.leaf.getTreeLeaf3D();
        BasicTreeLeafTest.assertEquals((int)1, (int)leaf3D.countSubscribers());
        leaf3D.deleteSubscriber((Subscriber)this.leaf);
        BasicTreeLeafTest.assertEquals((int)0, (int)leaf3D.countSubscribers());
        this.publisherHelper.addSubscriberTo((Publisher)this.leaf);
        this.leaf.update((Publisher)leaf3D, (Object)MobileEvent.FALLING);
        BasicTreeLeafTest.assertEquals((int)0, (int)this.publisherHelper.nbUpdated());
        BasicTreeLeafTest.assertEquals((int)0, (int)this.publisherHelper.getUpdateObjects().size());
        this.leaf.update((Publisher)leaf3D, null);
        BasicTreeLeafTest.assertEquals((int)0, (int)this.publisherHelper.nbUpdated());
        BasicTreeLeafTest.assertEquals((int)0, (int)this.publisherHelper.getUpdateObjects().size());
        this.leaf.update((Publisher)leaf3D, (Object)LeafEvent.EFFICIENCY);
        BasicTreeLeafTest.assertEquals((int)0, (int)this.publisherHelper.nbUpdated());
        BasicTreeLeafTest.assertEquals((int)0, (int)this.publisherHelper.getUpdateObjects().size());
        this.leaf.update((Publisher)leaf3D, (Object)MobileEvent.FALLEN);
        BasicTreeLeafTest.assertEquals((int)1, (int)this.publisherHelper.nbUpdated());
        BasicTreeLeafTest.assertEquals((Object)MobileEvent.FALLEN, this.publisherHelper.getUpdateObjects().get(0));
    }

    public void testGetState() {
        BasicTreeLeafTest.assertEquals((Object)this.leafState, (Object)this.leaf.getState());
        BasicTreeLeafTest.assertSame((Object)this.leafState, (Object)this.leaf.getState());
        BigDecimal energy = this.leaf.getState().getEnergy();
        BigDecimal efficiency = this.leaf.getState().getEfficiency();
        this.leaf.improveEfficiency();
        BasicTreeLeafTest.assertEquals((Object)this.leafState, (Object)this.leaf.getState());
        BasicTreeLeafTest.assertSame((Object)this.leafState, (Object)this.leaf.getState());
        BasicTreeLeafTest.assertFalse((boolean)energy.equals(this.leaf.getState().getEnergy()));
        BasicTreeLeafTest.assertFalse((boolean)efficiency.equals(this.leaf.getState().getEfficiency()));
    }
}

