/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.process.BasicSynchronizerCore;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.Speed;
import barsuift.simLife.process.SynchronizerCoreState;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CyclicBarrier;

public class MockInstrumentedSynchronizerCore
extends BasicSynchronizerCore {
    private CyclicBarrier barrier;
    private int scheduleCalled;
    private List<ConditionalTask> tasksToSchedule;
    private int unscheduleCalled;
    private List<ConditionalTask> tasksToUnschedule;
    private int startCalled;
    private int stopCalled;
    private int synchronizeCalled;

    public MockInstrumentedSynchronizerCore(SynchronizerCoreState state) {
        super(state);
        this.reset();
    }

    public void reset() {
        this.barrier = new CyclicBarrier(1);
        this.scheduleCalled = 0;
        this.tasksToSchedule = new ArrayList<ConditionalTask>();
        this.unscheduleCalled = 0;
        this.tasksToUnschedule = new ArrayList<ConditionalTask>();
        this.startCalled = 0;
        this.stopCalled = 0;
        this.synchronizeCalled = 0;
    }

    public void setBarrier(CyclicBarrier barrier) {
        super.setBarrier(barrier);
        this.barrier = barrier;
    }

    public CyclicBarrier getBarrier() {
        return this.barrier;
    }

    public void setSpeed(Speed speed) {
        super.setSpeed(speed);
    }

    public Speed getSpeed() {
        return super.getSpeed();
    }

    public boolean isRunning() {
        return super.isRunning();
    }

    public void schedule(ConditionalTask task) {
        super.schedule(task);
        ++this.scheduleCalled;
        this.tasksToSchedule.add(task);
    }

    public int getNbScheduleCalled() {
        return this.scheduleCalled;
    }

    public List<ConditionalTask> getScheduledTasks() {
        return this.tasksToSchedule;
    }

    public void unschedule(ConditionalTask task) {
        super.unschedule(task);
        ++this.unscheduleCalled;
        this.tasksToUnschedule.add(task);
    }

    public int getNbUnscheduleCalled() {
        return this.unscheduleCalled;
    }

    public List<ConditionalTask> getUnscheduledTasks() {
        return this.tasksToUnschedule;
    }

    public void start() throws IllegalStateException {
        super.start();
        ++this.startCalled;
    }

    public int getNbStartCalled() {
        return this.startCalled;
    }

    public void stop() {
        super.stop();
        ++this.stopCalled;
    }

    public int getNbStopCalled() {
        return this.stopCalled;
    }

    public SynchronizerCoreState getState() {
        return super.getState();
    }

    public void synchronize() {
        super.synchronize();
        ++this.synchronizeCalled;
    }

    public int getNbSynchronizeCalled() {
        return this.synchronizeCalled;
    }
}

