/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.process.BasicSynchronizerCore;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.MockConditionalTask;
import barsuift.simLife.process.MockSingleSynchronizedTask;
import barsuift.simLife.process.Speed;
import barsuift.simLife.process.SynchronizedTask;
import barsuift.simLife.process.SynchronizerCoreState;
import java.util.concurrent.CyclicBarrier;
import junit.framework.TestCase;

public class BasicSynchronizerCoreTest
extends TestCase {
    private BasicSynchronizerCore synchro;
    private SynchronizerCoreState state;
    private MockConditionalTask task;
    private SynchronizedTask barrierReleaser;

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpWithBound(0);
    }

    private void setUpWithBound(int bound) {
        this.state = new SynchronizerCoreState(Speed.VERY_FAST);
        this.synchro = new BasicSynchronizerCore(this.state);
        this.task = new MockConditionalTask(new ConditionalTaskState(new CyclicConditionState(1, 0), new BoundConditionState(bound, 0)));
        this.synchro.schedule((ConditionalTask)this.task);
        CyclicBarrier barrier = new CyclicBarrier(2);
        this.synchro.setBarrier(barrier);
        this.barrierReleaser = new MockSingleSynchronizedTask();
        this.barrierReleaser.changeBarrier(barrier);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.state = null;
        this.synchro = null;
        this.task = null;
    }

    public void testSetBarrier() {
        try {
            this.synchro.setBarrier(new CyclicBarrier(1));
            BasicSynchronizerCoreTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.synchro = new BasicSynchronizerCore(this.state);
        try {
            this.synchro.setBarrier(null);
            BasicSynchronizerCoreTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetSpeed() {
        BasicSynchronizerCoreTest.assertEquals((Object)Speed.VERY_FAST, (Object)this.synchro.getSpeed());
        this.synchro.setSpeed(Speed.FAST);
        BasicSynchronizerCoreTest.assertEquals((Object)Speed.FAST, (Object)this.synchro.getSpeed());
        this.synchro.setSpeed(Speed.NORMAL);
        BasicSynchronizerCoreTest.assertEquals((Object)Speed.NORMAL, (Object)this.synchro.getSpeed());
    }

    public void testStart() throws InterruptedException {
        BasicSynchronizerCoreTest.assertFalse((boolean)this.synchro.isRunning());
        BasicSynchronizerCoreTest.assertEquals((int)0, (int)this.task.getNbExecuted());
        this.synchro.start();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertTrue((boolean)this.synchro.isRunning());
        BasicSynchronizerCoreTest.assertTrue((this.task.getNbExecuted() > 0 ? 1 : 0) != 0);
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertFalse((boolean)this.synchro.isRunning());
        int nbExecuted = this.task.getNbExecuted();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertEquals((int)nbExecuted, (int)this.task.getNbExecuted());
        new Thread((Runnable)this.barrierReleaser).start();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertEquals((int)nbExecuted, (int)this.task.getNbExecuted());
    }

    public void testStartWithBoundedTask() throws InterruptedException {
        this.setUpWithBound(1);
        BasicSynchronizerCoreTest.assertFalse((boolean)this.synchro.isRunning());
        BasicSynchronizerCoreTest.assertEquals((int)0, (int)this.task.getNbExecuted());
        BasicSynchronizerCoreTest.assertFalse((boolean)this.synchro.getTasks().contains(this.task));
        this.synchro.start();
        BasicSynchronizerCoreTest.assertTrue((boolean)this.synchro.getTasks().contains(this.task));
        Thread.sleep(150L);
        BasicSynchronizerCoreTest.assertTrue((boolean)this.synchro.isRunning());
        BasicSynchronizerCoreTest.assertEquals((int)1, (int)this.task.getNbExecuted());
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(125L);
        BasicSynchronizerCoreTest.assertFalse((boolean)this.synchro.isRunning());
        BasicSynchronizerCoreTest.assertEquals((int)1, (int)this.task.getNbExecuted());
        BasicSynchronizerCoreTest.assertFalse((boolean)this.synchro.getTasks().contains(this.task));
    }

    public void testPublisher() throws Exception {
        PublisherTestHelper publisherHelper = new PublisherTestHelper();
        publisherHelper.addSubscriberTo((Publisher)this.synchro);
        this.synchro.start();
        BasicSynchronizerCoreTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        BasicSynchronizerCoreTest.assertNull(publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        BasicSynchronizerCoreTest.assertNull(publisherHelper.getUpdateObjects().get(0));
    }

    public void testIllegalStateException() throws InterruptedException {
        try {
            this.synchro.stop();
            BasicSynchronizerCoreTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.synchro.start();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        try {
            this.synchro.start();
            BasicSynchronizerCoreTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetState() throws InterruptedException {
        BasicSynchronizerCoreTest.assertEquals((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizerCoreTest.assertSame((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizerCoreTest.assertEquals((Object)Speed.VERY_FAST, (Object)this.synchro.getState().getSpeed());
        this.synchro.setSpeed(Speed.FAST);
        BasicSynchronizerCoreTest.assertEquals((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizerCoreTest.assertSame((Object)this.state, (Object)this.synchro.getState());
        BasicSynchronizerCoreTest.assertEquals((Object)Speed.FAST, (Object)this.synchro.getState().getSpeed());
    }

    public void testSchedule() throws Exception {
        ConditionalTaskState conditionalTaskState = new ConditionalTaskState(new CyclicConditionState(1, 0), new BoundConditionState(0, 0));
        MockConditionalTask mockRun1 = new MockConditionalTask(conditionalTaskState);
        MockConditionalTask mockRun2 = new MockConditionalTask(conditionalTaskState);
        MockConditionalTask mockRun3 = new MockConditionalTask(conditionalTaskState);
        try {
            this.synchro.unschedule((ConditionalTask)mockRun1);
            BasicSynchronizerCoreTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.synchro.schedule((ConditionalTask)mockRun1);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertTrue((mockRun1.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun2.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun3.getNbExecuted() == 0 ? 1 : 0) != 0);
        mockRun1.resetNbExecuted();
        this.synchro.schedule((ConditionalTask)mockRun2);
        this.synchro.unschedule((ConditionalTask)mockRun2);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertTrue((mockRun1.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun2.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun3.getNbExecuted() == 0 ? 1 : 0) != 0);
        mockRun1.resetNbExecuted();
        this.synchro.schedule((ConditionalTask)mockRun2);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        this.synchro.unschedule((ConditionalTask)mockRun2);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertTrue((mockRun1.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun2.getNbExecuted() >= 1 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun3.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun1.getNbExecuted() > mockRun2.getNbExecuted() ? 1 : 0) != 0);
        mockRun1.resetNbExecuted();
        mockRun2.resetNbExecuted();
        this.synchro.schedule((ConditionalTask)mockRun3);
        this.synchro.unschedule((ConditionalTask)mockRun1);
        this.synchro.start();
        this.synchro.stop();
        this.barrierReleaser.run();
        Thread.sleep(500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicSynchronizerCoreTest.assertTrue((mockRun1.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun2.getNbExecuted() == 0 ? 1 : 0) != 0);
        BasicSynchronizerCoreTest.assertTrue((mockRun3.getNbExecuted() >= 1 ? 1 : 0) != 0);
    }
}

