/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.process;

import barsuift.simLife.condition.BoundConditionState;
import barsuift.simLife.condition.CyclicConditionState;
import barsuift.simLife.j3d.universe.MockUniverse3D;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import barsuift.simLife.process.BasicMainSynchronizer;
import barsuift.simLife.process.ConditionalTask;
import barsuift.simLife.process.ConditionalTaskState;
import barsuift.simLife.process.MainSynchronizerState;
import barsuift.simLife.process.MockConditionalTask;
import barsuift.simLife.process.MockInstrumentedSynchronizer3D;
import barsuift.simLife.process.MockInstrumentedSynchronizerCore;
import barsuift.simLife.process.MockSplitConditionalTask;
import barsuift.simLife.process.Speed;
import barsuift.simLife.process.SplitConditionalTask;
import barsuift.simLife.process.SplitConditionalTaskState;
import barsuift.simLife.process.Synchronizer3D;
import barsuift.simLife.process.Synchronizer3DState;
import barsuift.simLife.process.SynchronizerCore;
import barsuift.simLife.process.SynchronizerCoreState;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import junit.framework.TestCase;

public class BasicMainSynchronizerTest
extends TestCase {
    private BasicMainSynchronizer synchro;
    private MainSynchronizerState state;
    private MockInstrumentedSynchronizerCore synchronizerCore;
    private MockInstrumentedSynchronizer3D synchronizer3D;
    private MockSplitConditionalTask task3D;
    private MockConditionalTask taskCore;

    protected void setUp() throws Exception {
        super.setUp();
        Speed speed = Speed.VERY_FAST;
        this.setUpFromSpeed(speed);
    }

    private void setUpFromSpeed(Speed speed) {
        int stepSize = speed.getSpeed();
        MockUniverse mockUniverse = new MockUniverse();
        this.synchronizerCore = new MockInstrumentedSynchronizerCore(new SynchronizerCoreState(speed));
        mockUniverse.setSynchronizer((SynchronizerCore)this.synchronizerCore);
        ConditionalTaskState conditionalTaskState = new ConditionalTaskState(new CyclicConditionState(1, 0), new BoundConditionState(4, 0));
        this.taskCore = new MockConditionalTask(conditionalTaskState);
        this.synchronizerCore.schedule((ConditionalTask)this.taskCore);
        this.synchronizer3D = new MockInstrumentedSynchronizer3D(new Synchronizer3DState(stepSize));
        ((MockUniverse3D)mockUniverse.getUniverse3D()).setSynchronizer((Synchronizer3D)this.synchronizer3D);
        ConditionalTaskState conditionalTask3DState = new ConditionalTaskState(new CyclicConditionState(1, 0), new BoundConditionState(60, 0));
        this.task3D = new MockSplitConditionalTask(new SplitConditionalTaskState(conditionalTask3DState, stepSize));
        this.synchronizer3D.schedule((SplitConditionalTask)this.task3D);
        this.state = new MainSynchronizerState();
        this.synchro = new BasicMainSynchronizer(this.state, (Universe)mockUniverse);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.state = null;
        this.synchro = null;
        this.synchronizerCore = null;
        this.synchronizer3D = null;
        this.task3D = null;
        this.taskCore = null;
    }

    public void testSetSpeed() {
        BasicMainSynchronizerTest.assertEquals((Object)Speed.VERY_FAST, (Object)this.synchro.getSpeed());
        BasicMainSynchronizerTest.assertEquals((Object)Speed.VERY_FAST, (Object)this.synchronizerCore.getSpeed());
        BasicMainSynchronizerTest.assertEquals((int)Speed.VERY_FAST.getSpeed(), (int)this.synchronizer3D.getStepSize());
        this.synchro.setSpeed(Speed.FAST);
        BasicMainSynchronizerTest.assertEquals((Object)Speed.FAST, (Object)this.synchro.getSpeed());
        BasicMainSynchronizerTest.assertEquals((Object)Speed.FAST, (Object)this.synchronizerCore.getSpeed());
        BasicMainSynchronizerTest.assertEquals((int)Speed.FAST.getSpeed(), (int)this.synchronizer3D.getStepSize());
        this.synchro.setSpeed(Speed.NORMAL);
        BasicMainSynchronizerTest.assertEquals((Object)Speed.NORMAL, (Object)this.synchro.getSpeed());
        BasicMainSynchronizerTest.assertEquals((Object)Speed.NORMAL, (Object)this.synchronizerCore.getSpeed());
        BasicMainSynchronizerTest.assertEquals((int)Speed.NORMAL.getSpeed(), (int)this.synchronizer3D.getStepSize());
    }

    public void testOneStepNormal() throws InterruptedException {
        this.internalTestOneStep(Speed.NORMAL);
    }

    public void testOneStepFast() throws InterruptedException {
        this.internalTestOneStep(Speed.FAST);
    }

    public void testOneStepVeryFast() throws InterruptedException {
        this.internalTestOneStep(Speed.VERY_FAST);
    }

    private void internalTestOneStep(Speed speed) throws InterruptedException {
        this.setUpFromSpeed(speed);
        this.synchro.oneStep();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertFalse((boolean)this.synchro.isRunning());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizerCore.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizerCore.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.taskCore.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizer3D.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizer3D.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)(20 / this.synchro.getSpeed().getSpeed()), (int)this.task3D.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)20, (int)this.task3D.getNbIncrementExecuted());
        this.synchro.oneStep();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertFalse((boolean)this.synchro.isRunning());
        BasicMainSynchronizerTest.assertEquals((int)2, (int)this.synchronizerCore.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)2, (int)this.synchronizerCore.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)2, (int)this.taskCore.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)2, (int)this.synchronizer3D.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)2, (int)this.synchronizer3D.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)(40 / this.synchro.getSpeed().getSpeed()), (int)this.task3D.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)40, (int)this.task3D.getNbIncrementExecuted());
        this.synchro.oneStep();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertFalse((boolean)this.synchro.isRunning());
        BasicMainSynchronizerTest.assertEquals((int)3, (int)this.synchronizerCore.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)3, (int)this.synchronizerCore.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)3, (int)this.taskCore.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)3, (int)this.synchronizer3D.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)3, (int)this.synchronizer3D.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)(60 / this.synchro.getSpeed().getSpeed()), (int)this.task3D.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)60, (int)this.task3D.getNbIncrementExecuted());
        this.synchro.oneStep();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertFalse((boolean)this.synchro.isRunning());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.synchronizerCore.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.synchronizerCore.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.taskCore.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.synchronizer3D.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.synchronizer3D.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)(60 / this.synchro.getSpeed().getSpeed()), (int)this.task3D.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)60, (int)this.task3D.getNbIncrementExecuted());
        this.synchro.oneStep();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertFalse((boolean)this.synchro.isRunning());
        BasicMainSynchronizerTest.assertEquals((int)5, (int)this.synchronizerCore.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)5, (int)this.synchronizerCore.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.taskCore.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)5, (int)this.synchronizer3D.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)5, (int)this.synchronizer3D.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)(60 / this.synchro.getSpeed().getSpeed()), (int)this.task3D.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)60, (int)this.task3D.getNbIncrementExecuted());
    }

    public void testStartNormal() throws InterruptedException {
        this.internalTestStart(Speed.NORMAL);
    }

    public void testStartFast() throws InterruptedException {
        this.internalTestStart(Speed.FAST);
    }

    public void testStartVeryFast() throws InterruptedException {
        this.internalTestStart(Speed.VERY_FAST);
    }

    private void internalTestStart(Speed speed) throws InterruptedException {
        this.setUpFromSpeed(speed);
        BasicMainSynchronizerTest.assertFalse((boolean)this.synchro.isRunning());
        this.synchro.start();
        Thread.sleep(2500 / this.synchro.getSpeed().getSpeed() + 100);
        BasicMainSynchronizerTest.assertTrue((boolean)this.synchro.isRunning());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizerCore.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)0, (int)this.synchronizerCore.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.taskCore.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizer3D.getNbStartCalled());
        BasicMainSynchronizerTest.assertEquals((int)0, (int)this.synchronizer3D.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)(60 / this.synchro.getSpeed().getSpeed()), (int)this.task3D.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)60, (int)this.task3D.getNbIncrementExecuted());
        this.synchro.stop();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertFalse((boolean)this.synchro.isRunning());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizerCore.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)4, (int)this.taskCore.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)1, (int)this.synchronizer3D.getNbStopCalled());
        BasicMainSynchronizerTest.assertEquals((int)(60 / this.synchro.getSpeed().getSpeed()), (int)this.task3D.getNbExecuted());
        BasicMainSynchronizerTest.assertEquals((int)60, (int)this.task3D.getNbIncrementExecuted());
    }

    public void testPublisher() throws Exception {
        PublisherTestHelper publisherHelper = new PublisherTestHelper();
        publisherHelper.addSubscriberTo((Publisher)this.synchro);
        this.synchro.start();
        BasicMainSynchronizerTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        BasicMainSynchronizerTest.assertNull(publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        this.synchro.stop();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertEquals((int)1, (int)publisherHelper.nbUpdated());
        BasicMainSynchronizerTest.assertNull(publisherHelper.getUpdateObjects().get(0));
        publisherHelper.reset();
        this.synchro.oneStep();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        BasicMainSynchronizerTest.assertEquals((int)2, (int)publisherHelper.nbUpdated());
        BasicMainSynchronizerTest.assertNull(publisherHelper.getUpdateObjects().get(0));
    }

    public void testIllegalStateException() throws InterruptedException {
        try {
            this.synchro.stop();
            BasicMainSynchronizerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.synchro.start();
        Thread.sleep(1000 / this.synchro.getSpeed().getSpeed() + 50);
        try {
            this.synchro.start();
            BasicMainSynchronizerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        try {
            this.synchro.oneStep();
            BasicMainSynchronizerTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetState() throws InterruptedException {
        BasicMainSynchronizerTest.assertEquals((Object)this.state, (Object)this.synchro.getState());
        BasicMainSynchronizerTest.assertSame((Object)this.state, (Object)this.synchro.getState());
    }
}

