/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.environment;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.BasicSun;
import barsuift.simLife.environment.SunState;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.PublisherTestHelper;
import junit.framework.TestCase;

public class BasicSunTest
extends TestCase {
    private PublisherTestHelper publisherHelper;
    private SunState sunState;
    private BasicSun sun;

    protected void setUp() throws Exception {
        super.setUp();
        this.sunState = new SunState();
        this.sun = new BasicSun(this.sunState);
        this.publisherHelper = new PublisherTestHelper();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.sun = null;
        this.publisherHelper = null;
    }

    public void testConstructor() {
        try {
            new BasicSun(null);
            BasicSunTest.fail((String)"Should throw new IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        BasicSunTest.assertEquals((Object)this.sunState, (Object)this.sun.getState());
        BasicSunTest.assertSame((Object)this.sunState, (Object)this.sun.getState());
        BasicSunTest.assertEquals((Object)0.0, (Object)this.sun.getState().getBrightness().doubleValue());
        BasicSunTest.assertEquals((Object)0.0, (Object)this.sun.getState().getRiseAngle().doubleValue());
        BasicSunTest.assertEquals((Object)0.0, (Object)this.sun.getState().getZenithAngle().doubleValue());
        this.sun.setBrightness(PercentHelper.getDecimalValue((int)32));
        this.sun.setRiseAngle(PercentHelper.getDecimalValue((int)47));
        this.sun.setZenithAngle(PercentHelper.getDecimalValue((int)78));
        BasicSunTest.assertEquals((Object)this.sunState, (Object)this.sun.getState());
        BasicSunTest.assertSame((Object)this.sunState, (Object)this.sun.getState());
        BasicSunTest.assertEquals((Object)0.32, (Object)this.sun.getState().getBrightness().doubleValue());
        BasicSunTest.assertEquals((Object)0.47, (Object)this.sun.getState().getRiseAngle().doubleValue());
        BasicSunTest.assertEquals((Object)0.78, (Object)this.sun.getState().getZenithAngle().doubleValue());
    }

    public void testGetBrightness() {
        this.sun.setBrightness(PercentHelper.getDecimalValue((int)30));
        BasicSunTest.assertEquals((Object)PercentHelper.getDecimalValue((int)30), (Object)this.sun.getBrightness());
        try {
            this.sun.setBrightness(null);
            BasicSunTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetRiseAngle() {
        this.sun.setRiseAngle(PercentHelper.getDecimalValue((int)30));
        BasicSunTest.assertEquals((Object)PercentHelper.getDecimalValue((int)30), (Object)this.sun.getRiseAngle());
        try {
            this.sun.setRiseAngle(null);
            BasicSunTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetZenithAngle() {
        this.sun.setZenithAngle(PercentHelper.getDecimalValue((int)30));
        BasicSunTest.assertEquals((Object)PercentHelper.getDecimalValue((int)30), (Object)this.sun.getZenithAngle());
        try {
            this.sun.setZenithAngle(null);
            BasicSunTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubscriberBrightness() {
        this.publisherHelper.addSubscriberTo((Publisher)this.sun);
        BasicSunTest.assertEquals((Object)this.sunState.getBrightness(), (Object)this.sun.getBrightness());
        this.sun.setBrightness(PercentHelper.getDecimalValue((int)90));
        BasicSunTest.assertEquals((Object)PercentHelper.getDecimalValue((int)90), (Object)this.sun.getBrightness());
        BasicSunTest.assertEquals((int)1, (int)this.publisherHelper.nbUpdated());
        BasicSunTest.assertEquals((Object)SunUpdateCode.brightness, this.publisherHelper.getUpdateObjects().get(0));
    }

    public void testSubscriberBrightnessUnchanged() {
        this.publisherHelper.addSubscriberTo((Publisher)this.sun);
        BasicSunTest.assertEquals((Object)this.sunState.getBrightness(), (Object)this.sun.getBrightness());
        this.sun.setBrightness(this.sunState.getBrightness());
        BasicSunTest.assertEquals((Object)this.sunState.getBrightness(), (Object)this.sun.getBrightness());
        BasicSunTest.assertEquals((String)"The subscriber should not be notified when setting the same value as before", (int)0, (int)this.publisherHelper.nbUpdated());
        BasicSunTest.assertEquals((int)0, (int)this.publisherHelper.getUpdateObjects().size());
    }

    public void testSubscriberRiseAngle() {
        this.publisherHelper.addSubscriberTo((Publisher)this.sun);
        BasicSunTest.assertEquals((Object)this.sunState.getRiseAngle(), (Object)this.sun.getRiseAngle());
        this.sun.setRiseAngle(PercentHelper.getDecimalValue((int)50));
        BasicSunTest.assertEquals((Object)PercentHelper.getDecimalValue((int)50), (Object)this.sun.getRiseAngle());
        BasicSunTest.assertEquals((int)1, (int)this.publisherHelper.nbUpdated());
        BasicSunTest.assertEquals((Object)SunUpdateCode.riseAngle, this.publisherHelper.getUpdateObjects().get(0));
    }

    public void testSubscriberRiseAngleUnchanged() {
        this.publisherHelper.addSubscriberTo((Publisher)this.sun);
        BasicSunTest.assertEquals((Object)this.sunState.getRiseAngle(), (Object)this.sun.getRiseAngle());
        this.sun.setRiseAngle(this.sunState.getRiseAngle());
        BasicSunTest.assertEquals((Object)this.sunState.getRiseAngle(), (Object)this.sun.getRiseAngle());
        BasicSunTest.assertEquals((String)"The subscriber should not be notified when setting the same value as before", (int)0, (int)this.publisherHelper.nbUpdated());
        BasicSunTest.assertEquals((int)0, (int)this.publisherHelper.getUpdateObjects().size());
    }

    public void testSubscriberZenithAngle() {
        this.publisherHelper.addSubscriberTo((Publisher)this.sun);
        BasicSunTest.assertEquals((Object)this.sunState.getZenithAngle(), (Object)this.sun.getZenithAngle());
        this.sun.setZenithAngle(PercentHelper.getDecimalValue((int)75));
        BasicSunTest.assertEquals((Object)PercentHelper.getDecimalValue((int)75), (Object)this.sun.getZenithAngle());
        BasicSunTest.assertEquals((int)1, (int)this.publisherHelper.nbUpdated());
        BasicSunTest.assertEquals((Object)SunUpdateCode.zenithAngle, this.publisherHelper.getUpdateObjects().get(0));
    }

    public void testSubscriberZenithAngleUnchanged() {
        this.publisherHelper.addSubscriberTo((Publisher)this.sun);
        BasicSunTest.assertEquals((Object)this.sunState.getZenithAngle(), (Object)this.sun.getZenithAngle());
        this.sun.setZenithAngle(this.sunState.getZenithAngle());
        BasicSunTest.assertEquals((Object)this.sunState.getZenithAngle(), (Object)this.sun.getZenithAngle());
        BasicSunTest.assertEquals((String)"The subscriber should not be notified when setting the same value as before", (int)0, (int)this.publisherHelper.nbUpdated());
        BasicSunTest.assertEquals((int)0, (int)this.publisherHelper.getUpdateObjects().size());
    }
}

