/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.Randomizer;
import barsuift.simLife.environment.EnvironmentState;
import barsuift.simLife.environment.EnvironmentStateFactory;
import barsuift.simLife.time.TimeCounterState;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.tree.TreeStateFactory;
import barsuift.simLife.universe.UniverseState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.vecmath.Point3d;

public class UniverseStateFactory {
    private static final Map<Long, Point3d> originPoints = new HashMap<Long, Point3d>();

    public UniverseState createRandomUniverseState() {
        boolean fpsShowing = false;
        int nbTrees = Randomizer.randomBetween((int)1, (int)4);
        TreeStateFactory treeStateFactory = new TreeStateFactory();
        HashSet<TreeState> trees = new HashSet<TreeState>(nbTrees);
        for (int i = 0; i < nbTrees; ++i) {
            Point3d translationVector = originPoints.get(new Long(i));
            trees.add(treeStateFactory.createRandomTreeState(translationVector));
        }
        HashSet fallenLeaves = new HashSet(0);
        EnvironmentStateFactory envStateFactory = new EnvironmentStateFactory();
        EnvironmentState environment = envStateFactory.createEnvironmentState();
        return new UniverseState(0, fpsShowing, trees, fallenLeaves, environment, new TimeCounterState());
    }

    public UniverseState createEmptyUniverseState() {
        boolean fpsShowing = false;
        HashSet trees = new HashSet(0);
        HashSet fallenLeaves = new HashSet(0);
        EnvironmentStateFactory envStateFactory = new EnvironmentStateFactory();
        EnvironmentState environment = envStateFactory.createEnvironmentState();
        return new UniverseState(0, fpsShowing, trees, fallenLeaves, environment, new TimeCounterState());
    }

    static {
        originPoints.put(new Long(0L), new Point3d(0.0, 0.0, 0.0));
        originPoints.put(new Long(1L), new Point3d(5.0, 0.0, 0.0));
        originPoints.put(new Long(2L), new Point3d(2.0, 0.0, -4.0));
        originPoints.put(new Long(3L), new Point3d(-4.0, 0.0, 2.0));
    }
}

