/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.j3d.Axis3DGroup;
import barsuift.simLife.j3d.BasicSimLifeCanvas3D;
import barsuift.simLife.j3d.SimLifeCanvas3D;
import barsuift.simLife.time.UniverseTimeController;
import barsuift.simLife.universe.BasicUniverse;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseContext;
import barsuift.simLife.universe.UniverseContextState;
import barsuift.simLife.universe.UniverseContextStateFactory;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

public class BasicUniverseContext
implements UniverseContext {
    private static final BoundingSphere BOUNDS_FOR_ALL = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
    private final UniverseContextState state;
    private boolean axisShowing;
    private final BasicSimLifeCanvas3D canvas3D;
    private final Universe universe;
    private final UniverseTimeController timeController;
    private final TransformGroup viewTransform;
    private final BranchGroup root;
    private final Axis3DGroup axisGroup = new Axis3DGroup();

    public BasicUniverseContext(UniverseContextState state) {
        this.state = state;
        this.axisShowing = state.isAxisShowing();
        this.universe = new BasicUniverse(state.getUniverseState());
        this.timeController = new UniverseTimeController(this.universe);
        this.canvas3D = new BasicSimLifeCanvas3D(this.universe.getFpsCounter(), state.getCanvasState());
        SimpleUniverse simpleU = new SimpleUniverse((Canvas3D)this.canvas3D);
        simpleU.getViewer().getView().setMinimumFrameCycleTime(25L);
        this.root = new BranchGroup();
        this.root.setCapability(14);
        this.root.setCapability(13);
        this.viewTransform = simpleU.getViewingPlatform().getViewPlatformTransform();
        this.viewTransform.setTransform(new Transform3D(state.getViewerTransform3D()));
        this.addNavigators();
        this.root.addChild((Node)this.universe.getUniverse3D().getUniverseRoot());
        this.root.compile();
        simpleU.addBranchGraph(this.root);
        this.setAxisShowing(state.isAxisShowing());
    }

    public SimLifeCanvas3D getCanvas3D() {
        return this.canvas3D;
    }

    public Universe getUniverse() {
        return this.universe;
    }

    public UniverseTimeController getUniverseTimeController() {
        return this.timeController;
    }

    public void setFpsShowing(boolean fpsShowing) {
        this.universe.setFpsShowing(fpsShowing);
        this.canvas3D.setFpsShowing(fpsShowing);
    }

    public boolean isFpsShowing() {
        return this.universe.isFpsShowing() && this.canvas3D.isFpsShowing();
    }

    public void setAxisShowing(boolean axisShowing) {
        if (axisShowing) {
            this.root.addChild((Node)this.axisGroup);
        } else {
            this.root.removeChild((Node)this.axisGroup);
        }
        this.axisShowing = axisShowing;
    }

    public boolean isAxisShowing() {
        return this.axisShowing;
    }

    public void resetToOriginalView() {
        this.viewTransform.setTransform(new Transform3D(UniverseContextStateFactory.NOMINAL_VIEWER_TRANSFORM));
    }

    public void resetToNominalAngleOfView() {
        Transform3D viewingTransform = new Transform3D();
        this.viewTransform.getTransform(viewingTransform);
        Quat4d rotationQuat = new Quat4d();
        viewingTransform.get(rotationQuat);
        rotationQuat.x = 0.0;
        rotationQuat.z = 0.0;
        viewingTransform.setRotation(rotationQuat);
        Vector3d currentTranslation = new Vector3d();
        viewingTransform.get(currentTranslation);
        currentTranslation.y = 2.0;
        viewingTransform.setTranslation(currentTranslation);
        this.viewTransform.setTransform(viewingTransform);
    }

    public UniverseContextState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setAxisShowing(this.axisShowing);
        Transform3D transform3D = new Transform3D();
        this.viewTransform.getTransform(transform3D);
        double[] matrix = new double[16];
        transform3D.get(matrix);
        this.state.setViewerTransform3D(matrix);
        this.canvas3D.synchronize();
        this.universe.synchronize();
    }

    private void addNavigators() {
        KeyNavigatorBehavior navigator = this.createKeyboardNavigator();
        this.root.addChild((Node)navigator);
        MouseTranslate mouseTranslateNavigator = this.createMouseTranslateNavigator();
        this.root.addChild((Node)mouseTranslateNavigator);
        MouseZoom mouseZoomNavigator = this.createMouseZoomNavigator();
        this.root.addChild((Node)mouseZoomNavigator);
    }

    private KeyNavigatorBehavior createKeyboardNavigator() {
        KeyNavigatorBehavior keyNavigator = new KeyNavigatorBehavior(this.viewTransform);
        keyNavigator.setSchedulingBounds((Bounds)BOUNDS_FOR_ALL);
        return keyNavigator;
    }

    private MouseTranslate createMouseTranslateNavigator() {
        MouseTranslate mouseTranslateNavigator = new MouseTranslate(2);
        mouseTranslateNavigator.setTransformGroup(this.viewTransform);
        mouseTranslateNavigator.setSchedulingBounds((Bounds)BOUNDS_FOR_ALL);
        return mouseTranslateNavigator;
    }

    private MouseZoom createMouseZoomNavigator() {
        MouseZoom mouseZoomNavigator = new MouseZoom(2);
        mouseZoomNavigator.setTransformGroup(this.viewTransform);
        mouseZoomNavigator.setSchedulingBounds((Bounds)BOUNDS_FOR_ALL);
        return mouseZoomNavigator;
    }
}

