/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.LivingPart;
import barsuift.simLife.environment.BasicEnvironment;
import barsuift.simLife.environment.Environment;
import barsuift.simLife.j3d.universe.BasicUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.time.FpsCounter;
import barsuift.simLife.time.TimeCounter;
import barsuift.simLife.tree.BasicTree;
import barsuift.simLife.tree.BasicTreeLeaf;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BasicUniverse
implements Universe {
    private final UniverseState state;
    private int age;
    private boolean fpsShowing;
    private final List<Tree> trees;
    private final List<TreeLeaf> fallenLeaves;
    private final Environment environment;
    private final BasicUniverse3D universe3D;
    private final TimeCounter counter;
    private final FpsCounter fpsCounter;

    public BasicUniverse(UniverseState state) {
        this.state = state;
        this.fpsCounter = new FpsCounter();
        this.fpsShowing = state.isFpsShowing();
        this.counter = new TimeCounter(state.getTimeCounter());
        this.age = state.getAge();
        this.universe3D = new BasicUniverse3D();
        this.environment = new BasicEnvironment(state.getEnvironment());
        this.trees = new ArrayList<Tree>();
        Set treeStates = state.getTrees();
        for (TreeState treeState : treeStates) {
            BasicTree newTree = new BasicTree(this, treeState);
            this.trees.add(newTree);
            System.out.println("nb Leaves=" + newTree.getNbLeaves());
        }
        this.fallenLeaves = new ArrayList<TreeLeaf>();
        Set fallenLeafStates = state.getFallenLeaves();
        for (TreeLeafState fallenLeafState : fallenLeafStates) {
            this.fallenLeaves.add(new BasicTreeLeaf(this, fallenLeafState));
        }
        this.universe3D.initFromUniverse((Universe)this);
    }

    public int getAge() {
        return this.age;
    }

    public FpsCounter getFpsCounter() {
        return this.fpsCounter;
    }

    public void setFpsShowing(boolean fpsShowing) {
        this.fpsShowing = fpsShowing;
    }

    public boolean isFpsShowing() {
        return this.fpsShowing;
    }

    public void spendTime() {
        if (this.fpsShowing) {
            this.fpsCounter.tick();
        }
        this.counter.increment();
        ++this.age;
        for (LivingPart livingPart : this.getLivingParts()) {
            livingPart.spendTime();
        }
    }

    public List<LivingPart> getLivingParts() {
        ArrayList<Tree> livingParts = new ArrayList<Tree>();
        livingParts.addAll(this.trees);
        return Collections.unmodifiableList(livingParts);
    }

    public List<Tree> getTrees() {
        return Collections.unmodifiableList(this.trees);
    }

    public void addTree(Tree tree) {
        this.trees.add(tree);
    }

    public List<TreeLeaf> getFallenLeaves() {
        return Collections.unmodifiableList(this.fallenLeaves);
    }

    public void addFallenLeaf(TreeLeaf treeLeaf) {
        this.fallenLeaves.add(treeLeaf);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public TimeCounter getCounter() {
        return this.counter;
    }

    public UniverseState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setAge(this.age);
        this.state.setFpsShowing(this.fpsShowing);
        HashSet<TreeState> treeStates = new HashSet<TreeState>();
        for (Tree tree : this.trees) {
            treeStates.add((TreeState)tree.getState());
        }
        this.state.setTrees(treeStates);
        HashSet<TreeLeafState> fallenLeaveStates = new HashSet<TreeLeafState>();
        for (TreeLeaf leaf : this.fallenLeaves) {
            fallenLeaveStates.add((TreeLeafState)leaf.getState());
        }
        this.state.setFallenLeaves(fallenLeaveStates);
        this.environment.synchronize();
        this.counter.synchronize();
    }

    public Universe3D getUniverse3D() {
        return this.universe3D;
    }
}

