/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.j3d.tree.BasicTreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Observable;

public class BasicTreeLeaf
extends Observable
implements TreeLeaf {
    private static final BigDecimal ONE = new BigDecimal(1);
    private static final BigDecimal AGING_EFFICIENCY_DECREASE = PercentHelper.getDecimalValue((int)95);
    private static final BigDecimal LOWEST_EFFICIENCY_BEFORE_FALLING = PercentHelper.getDecimalValue((int)10);
    private static final BigDecimal ENERGY_RATIO_TO_KEEP = PercentHelper.getDecimalValue((int)66);
    private static final BigDecimal MAX_ENERGY = new BigDecimal(100);
    private final TreeLeafState state;
    private BigDecimal efficiency;
    private int age;
    private BigDecimal energy;
    private BigDecimal freeEnergy;
    private final TreeLeaf3D leaf3D;
    private final Universe universe;
    private int updateMask;

    public BasicTreeLeaf(Universe universe, TreeLeafState leafState) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (leafState == null) {
            throw new IllegalArgumentException("null leaf state");
        }
        this.state = leafState;
        this.efficiency = this.state.getEfficiency();
        this.age = this.state.getAge();
        this.energy = this.state.getEnergy();
        this.freeEnergy = this.state.getFreeEnergy();
        this.universe = universe;
        this.leaf3D = new BasicTreeLeaf3D(universe.getUniverse3D(), leafState.getLeaf3DState(), (TreeLeaf)this);
        this.updateMask = 0;
    }

    public void spendTime() {
        this.updateMask = 0;
        this.age();
        this.collectSolarEnergy();
        if (this.isTooWeak()) {
            this.fall();
        } else {
            this.useEnergy();
        }
        if (this.hasChanged()) {
            this.notifyObservers(this.updateMask);
        }
    }

    private void age() {
        ++this.age;
        this.setChanged();
        this.updateMask |= 4;
        this.efficiency = this.efficiency.multiply(AGING_EFFICIENCY_DECREASE);
        this.setChanged();
        this.updateMask |= 0x10;
    }

    private void collectSolarEnergy() {
        BigDecimal lightRate = this.universe.getEnvironment().getSun().getLuminosity();
        BigDecimal solarEnergyRateCollected = this.efficiency.multiply(lightRate);
        BigDecimal energyCollected = solarEnergyRateCollected.multiply(Sun.ENERGY_DENSITY).multiply(new BigDecimal(this.leaf3D.getArea()));
        BigDecimal energyCollectedForLeaf = energyCollected.multiply(ENERGY_RATIO_TO_KEEP);
        BigDecimal freeEnergyCollected = energyCollected.subtract(energyCollectedForLeaf);
        this.energy = this.energy.add(energyCollectedForLeaf);
        this.energy = this.energy.min(MAX_ENERGY);
        this.freeEnergy = this.freeEnergy.add(freeEnergyCollected).setScale(5, RoundingMode.HALF_DOWN);
        this.setChanged();
        this.updateMask |= 8;
    }

    public boolean isTooWeak() {
        return this.efficiency.compareTo(LOWEST_EFFICIENCY_BEFORE_FALLING) < 0;
    }

    private void fall() {
        this.universe.addFallenLeaf((TreeLeaf)this);
        this.setChanged();
        this.updateMask |= 2;
    }

    private void useEnergy() {
        this.improveEfficiency();
    }

    private void improveEfficiency() {
        BigDecimal maxEfficiencyToAdd = ONE.subtract(this.efficiency);
        BigDecimal efficiencyToAdd = maxEfficiencyToAdd.min(this.energy.movePointLeft(2));
        this.efficiency = this.efficiency.add(efficiencyToAdd).setScale(10, RoundingMode.HALF_DOWN);
        this.setChanged();
        this.updateMask |= 0x10;
        this.energy = this.energy.subtract(efficiencyToAdd.movePointRight(2)).setScale(5, RoundingMode.HALF_DOWN);
        this.setChanged();
        this.updateMask |= 8;
    }

    public BigDecimal getEfficiency() {
        return this.efficiency;
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public BigDecimal collectFreeEnergy() {
        BigDecimal currentFreeEnergy = this.freeEnergy;
        this.freeEnergy = new BigDecimal(0);
        return currentFreeEnergy;
    }

    public int getAge() {
        return this.age;
    }

    public TreeLeaf3D getTreeLeaf3D() {
        return this.leaf3D;
    }

    public TreeLeafState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setEfficiency(this.efficiency);
        this.state.setAge(this.age);
        this.state.setEnergy(this.energy);
        this.state.setFreeEnergy(this.freeEnergy);
        this.leaf3D.synchronize();
    }
}

