/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.j3d.tree.BasicTreeBranch3D;
import barsuift.simLife.j3d.tree.TreeBranch3D;
import barsuift.simLife.tree.BasicTreeBranchPart;
import barsuift.simLife.tree.TreeBranch;
import barsuift.simLife.tree.TreeBranchPart;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicTreeBranch
implements TreeBranch {
    private static final BigDecimal ENERGY_RATIO_TO_KEEP = PercentHelper.getDecimalValue((int)0);
    private static final BigDecimal MAX_ENERGY = new BigDecimal(200);
    private final TreeBranchState state;
    private final List<TreeBranchPart> parts;
    private final TreeBranch3D branch3D;
    private int age;
    private BigDecimal energy;
    private BigDecimal freeEnergy;

    public BasicTreeBranch(Universe universe, TreeBranchState state) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (state == null) {
            throw new IllegalArgumentException("null branch state");
        }
        this.state = state;
        this.age = state.getAge();
        this.energy = state.getEnergy();
        this.freeEnergy = state.getFreeEnergy();
        List partStates = state.getBranchPartStates();
        this.parts = new ArrayList<TreeBranchPart>(partStates.size());
        for (TreeBranchPartState treeBranchPartState : partStates) {
            BasicTreeBranchPart branchPart = new BasicTreeBranchPart(universe, treeBranchPartState);
            this.parts.add(branchPart);
        }
        this.branch3D = new BasicTreeBranch3D(universe.getUniverse3D(), state.getBranch3DState(), (TreeBranch)this);
    }

    public int getAge() {
        return this.age;
    }

    public void spendTime() {
        ++this.age;
        for (TreeBranchPart branchPart : this.parts) {
            branchPart.spendTime();
        }
        this.collectFreeEnergyFromParts();
    }

    private void collectFreeEnergyFromParts() {
        BigDecimal freeEnergyCollectedFromParts = new BigDecimal(0);
        for (TreeBranchPart part : this.parts) {
            freeEnergyCollectedFromParts = freeEnergyCollectedFromParts.add(part.collectFreeEnergy());
        }
        BigDecimal energyCollectedForBranch = freeEnergyCollectedFromParts.multiply(ENERGY_RATIO_TO_KEEP);
        BigDecimal freeEnergyCollected = freeEnergyCollectedFromParts.subtract(energyCollectedForBranch);
        this.energy = this.energy.add(energyCollectedForBranch);
        this.energy = this.energy.min(MAX_ENERGY);
        this.freeEnergy = this.freeEnergy.add(freeEnergyCollected);
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public BigDecimal collectFreeEnergy() {
        BigDecimal currentFreeEnergy = this.freeEnergy;
        this.freeEnergy = new BigDecimal(0);
        return currentFreeEnergy;
    }

    public int getNbLeaves() {
        int result = 0;
        for (TreeBranchPart branchPart : this.parts) {
            result += branchPart.getNbLeaves();
        }
        return result;
    }

    public List<TreeBranchPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public int getNbParts() {
        return this.parts.size();
    }

    public TreeBranchState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setAge(this.age);
        this.state.setEnergy(this.energy);
        this.state.setFreeEnergy(this.freeEnergy);
        ArrayList<TreeBranchPartState> branchPartStates = new ArrayList<TreeBranchPartState>();
        for (TreeBranchPart branchPart : this.parts) {
            branchPartStates.add((TreeBranchPartState)branchPart.getState());
        }
        this.state.setBranchPartStates(branchPartStates);
        this.branch3D.synchronize();
    }

    public TreeBranch3D getBranch3D() {
        return this.branch3D;
    }
}

