/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.tree.BasicTree3D;
import barsuift.simLife.j3d.tree.Tree3D;
import barsuift.simLife.tree.BasicTreeBranch;
import barsuift.simLife.tree.BasicTreeTrunk;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeBranch;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.tree.TreeTrunk;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class BasicTree
implements Tree {
    private static final BigDecimal MAX_ENERGY = new BigDecimal(4000);
    private final TreeState state;
    private int age;
    private BigDecimal energy;
    private float height;
    private final List<TreeBranch> branches;
    private final TreeTrunk trunk;
    private final Tree3D tree3D;

    public BasicTree(Universe universe, TreeState state) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (state == null) {
            throw new IllegalArgumentException("null tree state");
        }
        this.state = state;
        this.age = state.getAge();
        this.energy = state.getEnergy();
        this.height = state.getHeight();
        List branchStates = state.getBranches();
        this.branches = new ArrayList<TreeBranch>(branchStates.size());
        for (TreeBranchState treeBranchState : branchStates) {
            this.branches.add(new BasicTreeBranch(universe, treeBranchState));
        }
        this.trunk = new BasicTreeTrunk(universe, state.getTrunkState());
        this.tree3D = new BasicTree3D(universe.getUniverse3D(), state.getTree3DState(), (Tree)this);
    }

    public int getAge() {
        return this.age;
    }

    public void spendTime() {
        ++this.age;
        this.trunk.spendTime();
        for (TreeBranch branch : this.branches) {
            branch.spendTime();
        }
        this.collectFreeEnergyFromBranches();
    }

    private void collectFreeEnergyFromBranches() {
        BigDecimal freeEnergyCollectedFromBranches = new BigDecimal(0);
        for (TreeBranch branch : this.branches) {
            freeEnergyCollectedFromBranches = freeEnergyCollectedFromBranches.add(branch.collectFreeEnergy());
        }
        this.energy = this.energy.add(freeEnergyCollectedFromBranches);
        this.energy = this.energy.min(MAX_ENERGY);
    }

    public float getHeight() {
        return this.height;
    }

    public int getNbBranches() {
        return this.branches.size();
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public int getNbLeaves() {
        int result = 0;
        for (TreeBranch branch : this.branches) {
            result += branch.getNbLeaves();
        }
        return result;
    }

    public List<TreeBranch> getBranches() {
        return this.branches;
    }

    public TreeState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setAge(this.age);
        this.state.setEnergy(this.energy);
        this.state.setHeight(this.height);
        ArrayList<TreeBranchState> treeBranchStates = new ArrayList<TreeBranchState>();
        for (TreeBranch treeBranch : this.branches) {
            treeBranchStates.add((TreeBranchState)treeBranch.getState());
        }
        this.state.setBranches(treeBranchStates);
        this.trunk.synchronize();
        this.tree3D.synchronize();
    }

    public Tree3D getTree3D() {
        return this.tree3D;
    }

    public TreeTrunk getTrunk() {
        return this.trunk;
    }
}

