/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.environment;

import barsuift.simLife.environment.Sun;
import barsuift.simLife.environment.SunState;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.j3d.universe.environment.BasicSun3D;
import barsuift.simLife.j3d.universe.environment.Sun3D;
import java.math.BigDecimal;
import java.util.Observable;

public class BasicSun
extends Observable
implements Sun {
    private final SunState state;
    private BigDecimal luminosity;
    private BigDecimal riseAngle;
    private BigDecimal zenithAngle;
    private final Sun3D sun3D;

    public BasicSun(SunState state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("Null sun state");
        }
        this.state = state;
        this.luminosity = state.getLuminosity();
        this.riseAngle = state.getRiseAngle();
        this.zenithAngle = state.getZenithAngle();
        this.sun3D = new BasicSun3D((Sun)this);
    }

    public BigDecimal getLuminosity() {
        return this.luminosity;
    }

    public void setLuminosity(BigDecimal luminosity) throws IllegalArgumentException {
        if (luminosity == null) {
            throw new IllegalArgumentException("Sun luminosity can not be null");
        }
        if (!this.luminosity.equals(luminosity)) {
            this.luminosity = luminosity;
            this.setChanged();
            this.notifyObservers(SunUpdateCode.luminosity);
        }
    }

    public BigDecimal getRiseAngle() {
        return this.riseAngle;
    }

    public void setRiseAngle(BigDecimal riseAngle) {
        if (riseAngle == null) {
            throw new IllegalArgumentException("Sun rise angle can not be null");
        }
        if (!this.riseAngle.equals(riseAngle)) {
            this.riseAngle = riseAngle;
            this.setChanged();
            this.notifyObservers(SunUpdateCode.riseAngle);
        }
    }

    public BigDecimal getZenithAngle() {
        return this.zenithAngle;
    }

    public void setZenithAngle(BigDecimal zenithAngle) {
        if (zenithAngle == null) {
            throw new IllegalArgumentException("Sun zenith angle can not be null");
        }
        if (!this.zenithAngle.equals(zenithAngle)) {
            this.zenithAngle = zenithAngle;
            this.setChanged();
            this.notifyObservers(SunUpdateCode.zenithAngle);
        }
    }

    public SunState getState() {
        this.synchronize();
        return this.state;
    }

    public void synchronize() {
        this.state.setLuminosity(this.luminosity);
        this.state.setRiseAngle(this.riseAngle);
        this.state.setZenithAngle(this.zenithAngle);
    }

    public Sun3D getSun3D() {
        return this.sun3D;
    }
}

