/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.j3d.util.DistanceHelper;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.tree.TreeBranchStateFactory;
import java.math.BigDecimal;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;

public class TreeBranchStateFactoryTest
extends TestCase {
    private Vector3d translationVector;
    private Point3d branchEndPoint;
    private TreeBranchState branchState;
    private TreeBranchStateFactory factory;

    protected void setUp() throws Exception {
        super.setUp();
        this.translationVector = new Vector3d(1.5, 3.6, 8.9);
        this.branchEndPoint = new Point3d(1.0, 2.7, 3.0);
        this.factory = new TreeBranchStateFactory();
        this.branchState = this.factory.createRandomBranchState(this.translationVector, this.branchEndPoint);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.translationVector = null;
        this.branchEndPoint = null;
        this.factory = null;
        this.branchState = null;
    }

    public void testCreateBranchState() {
        TreeBranchStateFactoryTest.assertNotNull((Object)this.branchState.getBranch3DState());
        List branchPartStates = this.branchState.getBranchPartStates();
        TreeBranchStateFactoryTest.assertEquals((int)3, (int)branchPartStates.size());
        for (TreeBranchPartState treeBranchPartState : branchPartStates) {
            TreeBranchStateFactoryTest.assertNotNull((Object)treeBranchPartState);
            this.checkEndPoint(treeBranchPartState.getBranchPart3DState().getEndPoint().toPointValue());
        }
        TreeBranchStateFactoryTest.assertTrue((this.branchState.getAge() >= 0 ? 1 : 0) != 0);
        TreeBranchStateFactoryTest.assertTrue((this.branchState.getAge() <= 100 ? 1 : 0) != 0);
        TreeBranchStateFactoryTest.assertTrue((this.branchState.getEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeBranchStateFactoryTest.assertTrue((this.branchState.getEnergy().compareTo(new BigDecimal(100)) <= 0 ? 1 : 0) != 0);
        TreeBranchStateFactoryTest.assertTrue((this.branchState.getFreeEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeBranchStateFactoryTest.assertTrue((this.branchState.getFreeEnergy().compareTo(new BigDecimal(50)) <= 0 ? 1 : 0) != 0);
    }

    public void testComputeBranchPartEndPoint() {
        int nbParts = this.branchState.getBranchPartStates().size();
        Point3d partEndPoint = this.factory.computeBranchPartEndPoint(this.branchEndPoint, nbParts);
        this.checkEndPoint(partEndPoint);
    }

    private void checkEndPoint(Point3d partEndPoint) {
        int nbParts = this.branchState.getBranchPartStates().size();
        double branchLength = DistanceHelper.distanceFromOrigin((Point3d)this.branchEndPoint);
        double xLength = Math.abs(this.branchEndPoint.getX());
        double yLength = Math.abs(this.branchEndPoint.getY());
        double zLength = Math.abs(this.branchEndPoint.getZ());
        int xCoeff = 0.0 < this.branchEndPoint.getX() ? 1 : -1;
        int yCoeff = 0.0 < this.branchEndPoint.getY() ? 1 : -1;
        int zCoeff = 0.0 < this.branchEndPoint.getZ() ? 1 : -1;
        double xbounds1 = (double)xCoeff * 0.5 * xLength / (double)nbParts - (double)xCoeff * 0.1 * branchLength;
        double ybounds1 = (double)yCoeff * 0.5 * yLength / (double)nbParts - (double)yCoeff * 0.1 * branchLength;
        double zbounds1 = (double)zCoeff * 0.5 * zLength / (double)nbParts - (double)zCoeff * 0.1 * branchLength;
        Point3d bound1 = new Point3d(xbounds1, ybounds1, zbounds1);
        double xbounds2 = (double)xCoeff * 1.5 * xLength / (double)nbParts + (double)xCoeff * 0.1 * branchLength;
        double ybounds2 = (double)yCoeff * 1.5 * yLength / (double)nbParts + (double)yCoeff * 0.1 * branchLength;
        double zbounds2 = (double)zCoeff * 1.5 * zLength / (double)nbParts + (double)zCoeff * 0.1 * branchLength;
        Point3d bound2 = new Point3d(xbounds2, ybounds2, zbounds2);
        PointTestHelper.assertPointIsWithinBounds((Point3d)partEndPoint, (Point3d)bound1, (Point3d)bound2);
    }
}

