/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.Environment;
import barsuift.simLife.environment.MockEnvironment;
import barsuift.simLife.environment.MockSun;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.j3d.universe.physic.MockGravity;
import barsuift.simLife.time.ObservableTestHelper;
import barsuift.simLife.tree.BasicTreeLeaf;
import barsuift.simLife.tree.LeafUpdateMask;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.util.Observable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import junit.framework.TestCase;

public class BasicTreeLeafTest
extends TestCase {
    private BasicTreeLeaf leaf;
    private ObservableTestHelper observerHelper;
    private MockUniverse universe;
    private TreeLeafState leafState;
    private BranchGroup bg;
    private MockSun mockSun;

    protected void setUp() throws Exception {
        super.setUp();
        this.leafState = CoreDataCreatorForTests.createSpecificTreeLeafState();
        BigDecimal lightRate = PercentHelper.getDecimalValue((int)70);
        this.mockSun = new MockSun();
        this.mockSun.setLuminosity(lightRate);
        MockEnvironment mockEnv = new MockEnvironment();
        mockEnv.setSun((Sun)this.mockSun);
        this.universe = new MockUniverse();
        this.universe.setEnvironment((Environment)mockEnv);
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.observerHelper = new ObservableTestHelper();
        this.attachLeaf3DIn3dStructure();
    }

    private void attachLeaf3DIn3dStructure() {
        Node leafNode = this.leaf.getTreeLeaf3D().getNode();
        this.bg = new BranchGroup();
        TransformGroup tg = new TransformGroup();
        this.bg.addChild((Node)tg);
        tg.addChild(leafNode);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.mockSun = null;
        this.leaf = null;
        this.observerHelper = null;
        this.universe = null;
        this.leafState = null;
        this.bg = null;
    }

    public void testBasicTreeLeaf() {
        try {
            new BasicTreeLeaf(null, this.leafState);
            BasicTreeLeafTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeLeaf((Universe)this.universe, null);
            BasicTreeLeafTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSpendTime1() {
        this.observerHelper.addObserver((Observable)this.leaf);
        BasicTreeLeafTest.assertEquals((int)0, (int)this.observerHelper.nbUpdated());
        this.leaf.spendTime();
        BasicTreeLeafTest.assertEquals((int)1, (int)this.observerHelper.nbUpdated());
        int updateParam = (Integer)this.observerHelper.getUpdateObjects().get(0);
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)4));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)16));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)8));
        BasicTreeLeafTest.assertEquals((double)0.9021344013, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((double)0.0, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((double)5.17056, (double)this.leaf.collectFreeEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((Object)new BigDecimal(0), (Object)this.leaf.collectFreeEnergy());
        BasicTreeLeafTest.assertEquals((int)16, (int)this.leaf.getAge());
    }

    public void testSpendTime2() {
        this.leafState.setEfficiency(new BigDecimal("0.999999"));
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.observerHelper.addObserver((Observable)this.leaf);
        BasicTreeLeafTest.assertEquals((int)0, (int)this.observerHelper.nbUpdated());
        this.leaf.spendTime();
        BasicTreeLeafTest.assertEquals((int)1, (int)this.observerHelper.nbUpdated());
        int updateParam = (Integer)this.observerHelper.getUpdateObjects().get(0);
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)4));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)16));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)8));
        BasicTreeLeafTest.assertEquals((double)1.0, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((double)10.2667, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((double)5.7132, (double)this.leaf.collectFreeEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((Object)new BigDecimal(0), (Object)this.leaf.collectFreeEnergy());
        BasicTreeLeafTest.assertEquals((int)16, (int)this.leaf.getAge());
    }

    public void testSpendTime3() {
        this.leafState.setEfficiency(new BigDecimal("0.991"));
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.observerHelper.addObserver((Observable)this.leaf);
        BasicTreeLeafTest.assertEquals((int)0, (int)this.observerHelper.nbUpdated());
        this.leaf.spendTime();
        BasicTreeLeafTest.assertEquals((int)1, (int)this.observerHelper.nbUpdated());
        int updateParam = (Integer)this.observerHelper.getUpdateObjects().get(0);
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)4));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)16));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)8));
        BasicTreeLeafTest.assertEquals((double)1.0, (double)this.leaf.getEfficiency().doubleValue(), (double)1.0E-10);
        BasicTreeLeafTest.assertEquals((double)9.3644, (double)this.leaf.getEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((double)5.68878, (double)this.leaf.collectFreeEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeLeafTest.assertEquals((Object)new BigDecimal(0), (Object)this.leaf.collectFreeEnergy());
        BasicTreeLeafTest.assertEquals((int)16, (int)this.leaf.getAge());
    }

    public void testFall() {
        this.leafState.setEfficiency(PercentHelper.getDecimalValue((int)10));
        this.leaf = new BasicTreeLeaf((Universe)this.universe, this.leafState);
        this.attachLeaf3DIn3dStructure();
        this.observerHelper.addObserver((Observable)this.leaf);
        BasicTreeLeafTest.assertFalse((boolean)this.leaf.isTooWeak());
        this.leaf.spendTime();
        BasicTreeLeafTest.assertTrue((this.leaf.getEfficiency().doubleValue() < 0.1 ? 1 : 0) != 0);
        BasicTreeLeafTest.assertTrue((boolean)this.leaf.isTooWeak());
        BasicTreeLeafTest.assertEquals((int)1, (int)this.observerHelper.nbUpdated());
        int updateParam = (Integer)this.observerHelper.getUpdateObjects().get(0);
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)4));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)16));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)8));
        BasicTreeLeafTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)2));
        MockGravity gravity = (MockGravity)this.universe.getUniverse3D().getPhysics().getGravity();
        BasicTreeLeafTest.assertEquals((Object)this.bg, (Object)gravity.getFallenGroup());
    }

    public void testGetState() {
        BasicTreeLeafTest.assertEquals((Object)this.leafState, (Object)this.leaf.getState());
        BasicTreeLeafTest.assertSame((Object)this.leafState, (Object)this.leaf.getState());
        BasicTreeLeafTest.assertEquals((int)15, (int)this.leaf.getState().getAge());
        this.leaf.spendTime();
        BasicTreeLeafTest.assertEquals((Object)this.leafState, (Object)this.leaf.getState());
        BasicTreeLeafTest.assertSame((Object)this.leafState, (Object)this.leaf.getState());
        BasicTreeLeafTest.assertEquals((int)16, (int)this.leaf.getState().getAge());
    }
}

