/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.tree.BasicTreeLeafFactory;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import javax.vecmath.Point3d;
import junit.framework.TestCase;

public class BasicTreeLeafFactoryTest
extends TestCase {
    private BasicTreeLeafFactory factory;

    protected void setUp() throws Exception {
        super.setUp();
        MockUniverse universe = new MockUniverse();
        this.factory = new BasicTreeLeafFactory((Universe)universe);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
    }

    public void testCreateRandom() {
        Point3d leafAttachPoint = new Point3d(Math.random(), Math.random(), Math.random());
        TreeLeaf leaf = this.factory.createRandom(leafAttachPoint);
        TreeLeaf3DState leaf3dState = (TreeLeaf3DState)leaf.getTreeLeaf3D().getState();
        Tuple3dState initialEndPoint1 = leaf3dState.getInitialEndPoint1();
        Tuple3dState initialEndPoint2 = leaf3dState.getInitialEndPoint2();
        Tuple3dState expectedEndPoint1 = new Tuple3dState(initialEndPoint1.getX() * 10.0, initialEndPoint1.getY() * 10.0, initialEndPoint1.getZ() * 10.0);
        Tuple3dState expectedEndPoint2 = new Tuple3dState(initialEndPoint2.getX() * 10.0, initialEndPoint2.getY() * 10.0, initialEndPoint2.getZ() * 10.0);
        BasicTreeLeafFactoryTest.assertEquals((Object)expectedEndPoint1, (Object)leaf3dState.getEndPoint1());
        BasicTreeLeafFactoryTest.assertEquals((Object)expectedEndPoint2, (Object)leaf3dState.getEndPoint2());
    }

    public void testCreateNew() {
        Point3d leafAttachPoint = new Point3d(Math.random(), Math.random(), Math.random());
        BigDecimal energy = new BigDecimal(30);
        TreeLeaf leaf = this.factory.createNew(leafAttachPoint, energy);
        BasicTreeLeafFactoryTest.assertEquals((Object)energy, (Object)leaf.getEnergy());
        TreeLeaf3DState leaf3dState = (TreeLeaf3DState)leaf.getTreeLeaf3D().getState();
        BasicTreeLeafFactoryTest.assertEquals((Object)leaf3dState.getInitialEndPoint1(), (Object)leaf3dState.getEndPoint1());
        BasicTreeLeafFactoryTest.assertEquals((Object)leaf3dState.getInitialEndPoint2(), (Object)leaf3dState.getEndPoint2());
    }
}

