/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.MockSun;
import barsuift.simLife.tree.BasicTreeBranch;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import junit.framework.TestCase;

public class BasicTreeBranchTest
extends TestCase {
    private MockUniverse universe;
    private TreeBranchState branchState;
    private BasicTreeBranch branch;

    protected void setUp() throws Exception {
        super.setUp();
        this.universe = new MockUniverse();
        this.branchState = CoreDataCreatorForTests.createSpecificTreeBranchState();
        this.branch = new BasicTreeBranch((Universe)this.universe, this.branchState);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.universe = null;
        this.branchState = null;
        this.branch = null;
    }

    public void testBasicTreeBranch() {
        BasicTreeBranchTest.assertEquals((int)this.branchState.getBranchPartStates().size(), (int)this.branch.getNbParts());
        try {
            new BasicTreeBranch(null, this.branchState);
            BasicTreeBranchTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeBranch((Universe)this.universe, null);
            BasicTreeBranchTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSpendTime() {
        ((MockSun)this.universe.getEnvironment().getSun()).setLuminosity(PercentHelper.getDecimalValue((int)70));
        BasicTreeBranchTest.assertEquals((int)3, (int)this.branch.getNbParts());
        this.branch.spendTime();
        BasicTreeBranchTest.assertEquals((int)3, (int)this.branch.getNbParts());
        BasicTreeBranchTest.assertEquals((int)16, (int)this.branch.getAge());
        BasicTreeBranchTest.assertEquals((double)10.0, (double)this.branch.getEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeBranchTest.assertEquals((double)50.7792, (double)this.branch.collectFreeEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeBranchTest.assertEquals((Object)new BigDecimal(0), (Object)this.branch.collectFreeEnergy());
    }

    public void testGetState() {
        BasicTreeBranchTest.assertEquals((Object)this.branchState, (Object)this.branch.getState());
        BasicTreeBranchTest.assertSame((Object)this.branchState, (Object)this.branch.getState());
        BasicTreeBranchTest.assertEquals((int)15, (int)this.branch.getState().getAge());
        this.branch.spendTime();
        BasicTreeBranchTest.assertEquals((Object)this.branchState, (Object)this.branch.getState());
        BasicTreeBranchTest.assertSame((Object)this.branchState, (Object)this.branch.getState());
        BasicTreeBranchTest.assertEquals((int)16, (int)this.branch.getState().getAge());
    }
}

