/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.IObservable;
import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.MockSun;
import barsuift.simLife.j3d.Tuple3dState;
import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.j3d.tree.TreeBranchPart3DState;
import barsuift.simLife.j3d.tree.TreeLeaf3DState;
import barsuift.simLife.time.ObservableTestHelper;
import barsuift.simLife.tree.BasicTreeBranchPart;
import barsuift.simLife.tree.LeafUpdateMask;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.vecmath.Point3d;
import junit.framework.TestCase;

public class BasicTreeBranchPartTest
extends TestCase {
    private MockUniverse universe;
    private TreeBranchPartState branchPartState;
    private BasicTreeBranchPart branchPart;
    private TreeLeafState firstLeafState;

    protected void setUp() throws Exception {
        super.setUp();
        this.universe = new MockUniverse();
        this.branchPartState = CoreDataCreatorForTests.createSpecificTreeBranchPartState();
        this.firstLeafState = (TreeLeafState)this.branchPartState.getLeaveStates().get(0);
        this.firstLeafState.setEfficiency(PercentHelper.getDecimalValue((int)10));
        this.branchPart = new BasicTreeBranchPart((Universe)this.universe, this.branchPartState);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.firstLeafState = null;
        this.universe = null;
        this.branchPartState = null;
        this.branchPart = null;
    }

    public void testObservers() {
        for (TreeLeaf leaf : this.branchPart.getLeaves()) {
            BasicTreeBranchPartTest.assertEquals((int)2, (int)leaf.countObservers());
            leaf.deleteObserver((Observer)this.branchPart);
            BasicTreeBranchPartTest.assertEquals((int)1, (int)leaf.countObservers());
        }
    }

    public void testBasicTreeBranchPart() {
        BasicTreeBranchPartTest.assertEquals((int)this.branchPartState.getLeaveStates().size(), (int)this.branchPart.getLeaves().size());
        try {
            new BasicTreeBranchPart(null, this.branchPartState);
            BasicTreeBranchPartTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeBranchPart((Universe)this.universe, null);
            BasicTreeBranchPartTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSpendTime() {
        ((MockSun)this.universe.getEnvironment().getSun()).setLuminosity(PercentHelper.getDecimalValue((int)70));
        ArrayList<ObservableTestHelper> observerHelpers = new ArrayList<ObservableTestHelper>();
        for (TreeLeaf leaf : this.branchPart.getLeaves()) {
            ObservableTestHelper observerHelper = new ObservableTestHelper();
            observerHelpers.add(observerHelper);
            observerHelper.addIObserver((IObservable)leaf);
            BasicTreeBranchPartTest.assertEquals((int)0, (int)observerHelper.nbUpdated());
        }
        this.branchPart.spendTime();
        BasicTreeBranchPartTest.assertEquals((int)16, (int)this.branchPart.getAge());
        BasicTreeBranchPartTest.assertEquals((double)20.34112, (double)this.branchPart.getEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeBranchPartTest.assertEquals((double)13.34112, (double)this.branchPart.collectFreeEnergy().doubleValue(), (double)1.0E-5);
        BasicTreeBranchPartTest.assertEquals((Object)new BigDecimal(0), (Object)this.branchPart.collectFreeEnergy());
        int nbFall = 0;
        for (ObservableTestHelper observerHelper : observerHelpers) {
            BasicTreeBranchPartTest.assertEquals((int)1, (int)observerHelper.nbUpdated());
            int updateParam = (Integer)observerHelper.getUpdateObjects().get(0);
            if (LeafUpdateMask.isFieldSet((int)updateParam, (int)2)) {
                BasicTreeBranchPartTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)4));
                BasicTreeBranchPartTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)16));
                BasicTreeBranchPartTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)8));
                BasicTreeBranchPartTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)2));
                BasicTreeBranchPartTest.assertEquals((int)1, (int)(++nbFall));
                continue;
            }
            BasicTreeBranchPartTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)4));
            BasicTreeBranchPartTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)16));
            BasicTreeBranchPartTest.assertTrue((boolean)LeafUpdateMask.isFieldSet((int)updateParam, (int)8));
        }
        BasicTreeBranchPartTest.assertEquals((int)(this.branchPartState.getLeaveStates().size() - 1), (int)this.branchPart.getLeaves().size());
    }

    public void testGetState() {
        BasicTreeBranchPartTest.assertEquals((Object)this.branchPartState, (Object)this.branchPart.getState());
        BasicTreeBranchPartTest.assertSame((Object)this.branchPartState, (Object)this.branchPart.getState());
        BasicTreeBranchPartTest.assertEquals((int)15, (int)this.branchPart.getState().getAge());
        this.branchPart.spendTime();
        BasicTreeBranchPartTest.assertEquals((Object)this.branchPartState, (Object)this.branchPart.getState());
        BasicTreeBranchPartTest.assertSame((Object)this.branchPartState, (Object)this.branchPart.getState());
        BasicTreeBranchPartTest.assertEquals((int)16, (int)this.branchPart.getState().getAge());
    }

    public void testFallingLeaf() {
        this.branchPart = new BasicTreeBranchPart((Universe)this.universe, this.branchPartState);
        int nbLeaves = this.branchPart.getNbLeaves();
        this.branchPart.spendTime();
        BasicTreeBranchPartTest.assertEquals((String)"one leaf should have been removed", (int)(nbLeaves - 1), (int)this.branchPart.getNbLeaves());
        for (TreeLeaf leaf : this.branchPart.getLeaves()) {
            BasicTreeBranchPartTest.assertFalse((boolean)this.firstLeafState.equals((Object)leaf.getState()));
        }
        this.branchPart.update((Observable)this.branchPart.getLeaves().get(0), (Object)4);
        this.branchPart.update((Observable)this.branchPart.getLeaves().get(0), (Object)16);
        BasicTreeBranchPartTest.assertEquals((String)"no leaf should have been removed", (int)(nbLeaves - 1), (int)this.branchPart.getNbLeaves());
    }

    public void testComputeAttachPointForNewleafState1() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setLeafAttachPoint(new Tuple3dState(2.0, 0.0, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setLeafAttachPoint(new Tuple3dState(3.0, 0.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(2);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        TreeBranchPart3DState part3D = new TreeBranchPart3DState(new Tuple3dState(3.5, 0.0, 0.0));
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        partState.setBranchPart3DState(part3D);
        Point3d boundsStartPoint = new Point3d(0.8, 0.0, 0.0);
        Point3d boundsEndPoint = new Point3d(1.2, 0.0, 0.0);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        Point3d pointForNewLeaf = part.computeAttachPointForNewLeaf();
        PointTestHelper.assertPointIsWithinBounds((Point3d)pointForNewLeaf, (Point3d)boundsStartPoint, (Point3d)boundsEndPoint);
    }

    public void testComputeAttachPointForNewleafState2() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setLeafAttachPoint(new Tuple3dState(1.0, 0.0, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setLeafAttachPoint(new Tuple3dState(5.0, 0.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(2);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        TreeBranchPart3DState part3D = new TreeBranchPart3DState(new Tuple3dState(7.0, 0.0, 0.0));
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        partState.setBranchPart3DState(part3D);
        Point3d boundsStartPoint = new Point3d(2.6, 0.0, 0.0);
        Point3d boundsEndPoint = new Point3d(3.4, 0.0, 0.0);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        Point3d pointForNewLeaf = part.computeAttachPointForNewLeaf();
        PointTestHelper.assertPointIsWithinBounds((Point3d)pointForNewLeaf, (Point3d)boundsStartPoint, (Point3d)boundsEndPoint);
    }

    public void testComputeAttachPointForNewLeaf3() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setLeafAttachPoint(new Tuple3dState(2.0, 0.0, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setLeafAttachPoint(new Tuple3dState(3.0, 0.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(2);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        TreeBranchPart3DState part3D = new TreeBranchPart3DState(new Tuple3dState(6.0, 0.0, 0.0));
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        partState.setBranchPart3DState(part3D);
        Point3d boundsStartPoint = new Point3d(4.2, 0.0, 0.0);
        Point3d boundsEndPoint = new Point3d(4.8, 0.0, 0.0);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        Point3d pointForNewLeaf = part.computeAttachPointForNewLeaf();
        PointTestHelper.assertPointIsWithinBounds((Point3d)pointForNewLeaf, (Point3d)boundsStartPoint, (Point3d)boundsEndPoint);
    }

    public void testComputeAttachPointForNewLeaf4() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setLeafAttachPoint(new Tuple3dState(2.0, 0.0, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setLeafAttachPoint(new Tuple3dState(3.0, 0.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(2);
        leaveStates.add(leafState2);
        leaveStates.add(leafState1);
        TreeBranchPart3DState part3D = new TreeBranchPart3DState(new Tuple3dState(3.5, 0.0, 0.0));
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        partState.setBranchPart3DState(part3D);
        Point3d boundsStartPoint = new Point3d(0.8, 0.0, 0.0);
        Point3d boundsEndPoint = new Point3d(1.2, 0.0, 0.0);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        Point3d pointForNewLeaf = part.computeAttachPointForNewLeaf();
        PointTestHelper.assertPointIsWithinBounds((Point3d)pointForNewLeaf, (Point3d)boundsStartPoint, (Point3d)boundsEndPoint);
    }

    public void testCreateOneNewLeaf() {
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setEnergy(new BigDecimal(150));
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertEquals((int)0, (int)part.getNbLeaves());
        BasicTreeBranchPartTest.assertEquals((int)0, (int)part.getBranchPart3D().getLeaves().size());
        part.createOneNewLeaf();
        BasicTreeBranchPartTest.assertEquals((int)1, (int)part.getNbLeaves());
        BasicTreeBranchPartTest.assertEquals((int)1, (int)part.getBranchPart3D().getLeaves().size());
        TreeLeaf newLeaf = (TreeLeaf)part.getLeaves().get(part.getLeaves().size() - 1);
        BasicTreeBranchPartTest.assertEquals((int)2, (int)newLeaf.countObservers());
        newLeaf.deleteObserver((Observer)part);
        BasicTreeBranchPartTest.assertEquals((int)1, (int)newLeaf.countObservers());
        BasicTreeBranchPartTest.assertEquals((Object)new BigDecimal(60), (Object)part.getEnergy());
    }

    public void testCanCreateOneNewLeaf() {
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setEnergy(new BigDecimal(89));
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertFalse((boolean)part.canCreateOneNewLeaf());
        partState.setEnergy(new BigDecimal(150));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertTrue((boolean)part.canCreateOneNewLeaf());
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>();
        leaveStates.add(new TreeLeafState());
        leaveStates.add(new TreeLeafState());
        leaveStates.add(new TreeLeafState());
        partState.setLeaveStates(leaveStates);
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertTrue((boolean)part.canCreateOneNewLeaf());
        leaveStates.add(new TreeLeafState());
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertFalse((boolean)part.canCreateOneNewLeaf());
    }

    public void testShouldCreateOneNewLeaf() {
        boolean result;
        int i;
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setEnergy(new BigDecimal(89));
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertFalse((boolean)part.shouldCreateOneNewLeaf());
        partState.setEnergy(new BigDecimal(90));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        int sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldCreateOneNewLeaf();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertEquals((int)0, (int)sum);
        partState.setEnergy(new BigDecimal(153));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldCreateOneNewLeaf();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertTrue((sum > 650 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((sum < 750 ? 1 : 0) != 0);
        partState.setEnergy(new BigDecimal(180));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldCreateOneNewLeaf();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertEquals((int)1000, (int)sum);
        partState.setEnergy(new BigDecimal(250));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldCreateOneNewLeaf();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertEquals((int)1000, (int)sum);
    }

    public void testCanIncreaseOneLeafSize() {
        TreeBranchPartState partState = CoreDataCreatorForTests.createSpecificTreeBranchPartState();
        partState.setEnergy(new BigDecimal(19));
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertFalse((boolean)part.canIncreaseOneLeafSize());
        partState.setEnergy(new BigDecimal(20));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertTrue((boolean)part.canIncreaseOneLeafSize());
        for (TreeLeafState leafState : partState.getLeaveStates()) {
            TreeLeaf3DState leaf3dState = leafState.getLeaf3DState();
            Tuple3dState initialEndPoint1 = leaf3dState.getInitialEndPoint1();
            leaf3dState.setEndPoint1(new Tuple3dState(initialEndPoint1.getX() * 10.0, initialEndPoint1.getY() * 10.0, initialEndPoint1.getZ() * 10.0));
            Tuple3dState initialEndPoint2 = leaf3dState.getInitialEndPoint2();
            leaf3dState.setEndPoint2(new Tuple3dState(initialEndPoint2.getX() * 10.0, initialEndPoint2.getY() * 10.0, initialEndPoint2.getZ() * 10.0));
        }
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertFalse((boolean)part.canIncreaseOneLeafSize());
        ((TreeLeafState)partState.getLeaveStates().get(0)).getLeaf3DState().setEndPoint1(((TreeLeafState)partState.getLeaveStates().get(0)).getLeaf3DState().getInitialEndPoint1());
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertTrue((boolean)part.canIncreaseOneLeafSize());
    }

    public void testShouldIncreaseOneLeafSize() {
        boolean result;
        int i;
        TreeBranchPartState partState = CoreDataCreatorForTests.createSpecificTreeBranchPartState();
        partState.setEnergy(new BigDecimal(19));
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        BasicTreeBranchPartTest.assertFalse((boolean)part.shouldIncreaseOneLeafSize());
        partState.setEnergy(new BigDecimal(20));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        int sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldIncreaseOneLeafSize();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertEquals((int)0, (int)sum);
        partState.setEnergy(new BigDecimal(76));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldIncreaseOneLeafSize();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertTrue((sum > 650 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((sum < 750 ? 1 : 0) != 0);
        partState.setEnergy(new BigDecimal(100));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldIncreaseOneLeafSize();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertEquals((int)1000, (int)sum);
        partState.setEnergy(new BigDecimal(250));
        part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        sum = 0;
        for (i = 0; i < 1000; ++i) {
            result = part.shouldIncreaseOneLeafSize();
            sum += result ? 1 : 0;
        }
        BasicTreeBranchPartTest.assertEquals((int)1000, (int)sum);
    }

    public void testIncreaseOneLeafSize() {
        Point3d firstInitialEndPoint1 = this.firstLeafState.getLeaf3DState().getInitialEndPoint1().toPointValue();
        this.branchPartState.setEnergy(new BigDecimal(150));
        for (TreeLeafState leafState : this.branchPartState.getLeaveStates()) {
            TreeLeaf3DState leaf3dState = leafState.getLeaf3DState();
            Tuple3dState initialEndPoint1 = leaf3dState.getInitialEndPoint1();
            leaf3dState.setEndPoint1(new Tuple3dState(initialEndPoint1.getX() * 10.0, initialEndPoint1.getY() * 10.0, initialEndPoint1.getZ() * 10.0));
            Tuple3dState initialEndPoint2 = leaf3dState.getInitialEndPoint2();
            leaf3dState.setEndPoint2(new Tuple3dState(initialEndPoint2.getX() * 10.0, initialEndPoint2.getY() * 10.0, initialEndPoint2.getZ() * 10.0));
        }
        this.firstLeafState.getLeaf3DState().setEndPoint1(new Tuple3dState());
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), this.branchPartState);
        part.increaseOneLeafSize();
        PointTestHelper.assertPointEquals((Point3d)firstInitialEndPoint1, (Point3d)((TreeLeaf3DState)((TreeLeaf)part.getLeaves().get(0)).getTreeLeaf3D().getState()).getEndPoint1().toPointValue());
        BasicTreeBranchPartTest.assertEquals((Object)new BigDecimal(130), (Object)part.getEnergy());
        part.increaseOneLeafSize();
        Point3d expectedEndPoint = new Point3d(firstInitialEndPoint1.getX() * 2.0, firstInitialEndPoint1.getY() * 2.0, firstInitialEndPoint1.getZ() * 2.0);
        PointTestHelper.assertPointEquals((Point3d)expectedEndPoint, (Point3d)((TreeLeaf3DState)((TreeLeaf)part.getLeaves().get(0)).getTreeLeaf3D().getState()).getEndPoint1().toPointValue());
        BasicTreeBranchPartTest.assertEquals((Object)new BigDecimal(110), (Object)part.getEnergy());
    }

    public void testGetRandomLeafToIncrease1() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState1.setEndPoint2(new Tuple3dState(0.0, 2.0, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState2.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeaf3DState leaf3DState3 = new TreeLeaf3DState();
        leaf3DState3.setEndPoint1(new Tuple3dState(3.0, 0.0, 0.0));
        leaf3DState3.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        TreeLeafState leafState3 = new TreeLeafState();
        leafState3.setLeaf3DState(leaf3DState3);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(3);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        leaveStates.add(leafState3);
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        int sum1 = 0;
        int sum2 = 0;
        int sum3 = 0;
        for (int i = 0; i < 1000; ++i) {
            TreeLeaf leaf = part.getRandomLeafToIncrease();
            if (leaf.getState() == leafState1) {
                ++sum1;
            }
            if (leaf.getState() == leafState2) {
                ++sum2;
            }
            if (leaf.getState() != leafState3) continue;
            ++sum3;
        }
        BasicTreeBranchPartTest.assertTrue((String)("sum1=" + sum1), (sum1 > 370 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum1=" + sum1), (sum1 < 460 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum2=" + sum2), (sum2 > 290 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum2=" + sum2), (sum2 < 376 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum3=" + sum3), (sum3 > 210 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum3=" + sum3), (sum3 < 290 ? 1 : 0) != 0);
    }

    public void testGetRandomLeafToIncrease2() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState1.setEndPoint2(new Tuple3dState(0.0, 2.0, 0.0));
        leaf3DState1.setInitialEndPoint1(new Tuple3dState(0.2, 0.0, 0.0));
        leaf3DState1.setInitialEndPoint2(new Tuple3dState(0.0, 0.2, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState2.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeaf3DState leaf3DState3 = new TreeLeaf3DState();
        leaf3DState3.setEndPoint1(new Tuple3dState(3.0, 0.0, 0.0));
        leaf3DState3.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        TreeLeafState leafState3 = new TreeLeafState();
        leafState3.setLeaf3DState(leaf3DState3);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(3);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        leaveStates.add(leafState3);
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        int sum1 = 0;
        int sum2 = 0;
        int sum3 = 0;
        for (int i = 0; i < 1000; ++i) {
            TreeLeaf leaf = part.getRandomLeafToIncrease();
            if (leaf.getState() == leafState1) {
                ++sum1;
            }
            if (leaf.getState() == leafState2) {
                ++sum2;
            }
            if (leaf.getState() != leafState3) continue;
            ++sum3;
        }
        BasicTreeBranchPartTest.assertEquals((int)0, (int)sum1);
        BasicTreeBranchPartTest.assertTrue((String)("sum2=" + sum2), (sum2 > 540 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum2=" + sum2), (sum2 < 660 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum3=" + sum3), (sum3 > 340 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum3=" + sum3), (sum3 < 460 ? 1 : 0) != 0);
    }

    public void testGetRandomLeafToIncrease3() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState1.setEndPoint2(new Tuple3dState(0.0, 2.0, 0.0));
        leaf3DState1.setInitialEndPoint1(new Tuple3dState(0.2, 0.0, 0.0));
        leaf3DState1.setInitialEndPoint2(new Tuple3dState(0.0, 0.2, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState2.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        leaf3DState2.setInitialEndPoint1(new Tuple3dState(0.2, 0.0, 0.0));
        leaf3DState2.setInitialEndPoint2(new Tuple3dState(0.0, 0.4, 0.0));
        TreeLeaf3DState leaf3DState3 = new TreeLeaf3DState();
        leaf3DState3.setEndPoint1(new Tuple3dState(3.0, 0.0, 0.0));
        leaf3DState3.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        TreeLeafState leafState3 = new TreeLeafState();
        leafState3.setLeaf3DState(leaf3DState3);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(3);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        leaveStates.add(leafState3);
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        int sum1 = 0;
        int sum2 = 0;
        int sum3 = 0;
        for (int i = 0; i < 1000; ++i) {
            TreeLeaf leaf = part.getRandomLeafToIncrease();
            if (leaf.getState() == leafState1) {
                ++sum1;
            }
            if (leaf.getState() == leafState2) {
                ++sum2;
            }
            if (leaf.getState() != leafState3) continue;
            ++sum3;
        }
        BasicTreeBranchPartTest.assertEquals((int)0, (int)sum1);
        BasicTreeBranchPartTest.assertEquals((int)0, (int)sum2);
        BasicTreeBranchPartTest.assertEquals((int)1000, (int)sum3);
    }

    public void testGetRandomLeafToIncrease4() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setEndPoint1(new Tuple3dState(0.0, 0.0, 0.0));
        leaf3DState1.setEndPoint2(new Tuple3dState(0.0, 0.0, 0.0));
        leaf3DState1.setInitialEndPoint1(new Tuple3dState(0.2, 0.0, 0.0));
        leaf3DState1.setInitialEndPoint2(new Tuple3dState(0.0, 0.2, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState2.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeaf3DState leaf3DState3 = new TreeLeaf3DState();
        leaf3DState3.setEndPoint1(new Tuple3dState(3.0, 0.0, 0.0));
        leaf3DState3.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        TreeLeafState leafState3 = new TreeLeafState();
        leafState3.setLeaf3DState(leaf3DState3);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(3);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        leaveStates.add(leafState3);
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        int sum1 = 0;
        int sum2 = 0;
        int sum3 = 0;
        for (int i = 0; i < 1000; ++i) {
            TreeLeaf leaf = part.getRandomLeafToIncrease();
            if (leaf.getState() == leafState1) {
                ++sum1;
            }
            if (leaf.getState() == leafState2) {
                ++sum2;
            }
            if (leaf.getState() != leafState3) continue;
            ++sum3;
        }
        BasicTreeBranchPartTest.assertTrue((String)("sum1=" + sum1), (sum1 > 450 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum1=" + sum1), (sum1 < 550 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum2=" + sum2), (sum2 > 250 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum2=" + sum2), (sum2 < 350 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum3=" + sum3), (sum3 > 160 ? 1 : 0) != 0);
        BasicTreeBranchPartTest.assertTrue((String)("sum3=" + sum3), (sum3 < 240 ? 1 : 0) != 0);
    }

    public void testGetRandomLeafToIncrease5() {
        TreeLeaf3DState leaf3DState1 = new TreeLeaf3DState();
        leaf3DState1.setEndPoint1(new Tuple3dState(0.0, 0.0, 0.0));
        leaf3DState1.setEndPoint2(new Tuple3dState(0.0, 0.0, 0.0));
        leaf3DState1.setInitialEndPoint1(new Tuple3dState(0.2, 0.0, 0.0));
        leaf3DState1.setInitialEndPoint2(new Tuple3dState(0.0, 0.2, 0.0));
        TreeLeaf3DState leaf3DState2 = new TreeLeaf3DState();
        leaf3DState2.setEndPoint1(new Tuple3dState(2.0, 0.0, 0.0));
        leaf3DState2.setEndPoint2(new Tuple3dState(0.0, 4.0, 0.0));
        TreeLeafState leafState1 = new TreeLeafState();
        leafState1.setLeaf3DState(leaf3DState1);
        TreeLeafState leafState2 = new TreeLeafState();
        leafState2.setLeaf3DState(leaf3DState2);
        ArrayList<TreeLeafState> leaveStates = new ArrayList<TreeLeafState>(2);
        leaveStates.add(leafState1);
        leaveStates.add(leafState2);
        TreeBranchPartState partState = new TreeBranchPartState();
        partState.setLeaveStates(leaveStates);
        BasicTreeBranchPart part = new BasicTreeBranchPart((Universe)new MockUniverse(), partState);
        int sum1 = 0;
        int sum2 = 0;
        for (int i = 0; i < 1000; ++i) {
            TreeLeaf leaf = part.getRandomLeafToIncrease();
            if (leaf.getState() == leafState1) {
                ++sum1;
            }
            if (leaf.getState() != leafState2) continue;
            ++sum2;
        }
        BasicTreeBranchPartTest.assertEquals((int)1000, (int)sum1);
        BasicTreeBranchPartTest.assertEquals((int)0, (int)sum2);
    }
}

