/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.tree.BasicTreeTrunk3D;
import barsuift.simLife.j3d.tree.TreeTrunk3D;
import barsuift.simLife.j3d.tree.TreeTrunk3DState;
import barsuift.simLife.tree.TreeTrunk;
import barsuift.simLife.tree.TreeTrunkState;
import barsuift.simLife.universe.Universe;

public class BasicTreeTrunk
implements TreeTrunk {
    private Long id;
    private int age;
    private float radius;
    private float height;
    private TreeTrunk3D trunk3D;

    public BasicTreeTrunk(Universe universe, TreeTrunkState state) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (state == null) {
            throw new IllegalArgumentException("null trunk state");
        }
        this.id = state.getId();
        this.age = state.getAge();
        this.radius = state.getRadius();
        this.height = state.getHeight();
        this.trunk3D = new BasicTreeTrunk3D(universe.getUniverse3D(), state.getTrunk3DState(), (TreeTrunk)this);
    }

    public float getHeight() {
        return this.height;
    }

    public float getRadius() {
        return this.radius;
    }

    public TreeTrunkState getState() {
        TreeTrunk3DState trunk3DState = new TreeTrunk3DState();
        return new TreeTrunkState(this.id, this.age, this.radius, this.height, trunk3DState);
    }

    public Long getId() {
        return this.id;
    }

    public int getAge() {
        return this.age;
    }

    public void spendTime() {
        ++this.age;
    }

    public TreeTrunk3D getTreeTrunkD() {
        return this.trunk3D;
    }

    public String toString() {
        return "BasicTreeTrunk [age=" + this.age + ", height=" + this.height + ", id=" + this.id + ", radius=" + this.radius + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.age;
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + Float.floatToIntBits(this.radius);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicTreeTrunk other = (BasicTreeTrunk)obj;
        if (this.age != other.age) {
            return false;
        }
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return Float.floatToIntBits(this.radius) == Float.floatToIntBits(other.radius);
    }
}

