/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.LivingPart;
import barsuift.simLife.environment.BasicEnvironment;
import barsuift.simLife.environment.Environment;
import barsuift.simLife.j3d.universe.BasicUniverse3D;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.time.TimeCounter;
import barsuift.simLife.tree.BasicTree;
import barsuift.simLife.tree.BasicTreeLeaf;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseState;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BasicUniverse
implements Universe {
    private final Long id;
    private int age;
    private final Set<Tree> trees;
    private final Set<TreeLeaf> fallenLeaves;
    private Environment environment;
    private BasicUniverse3D universe3D;
    private final TimeCounter counter;

    public BasicUniverse(UniverseState state) {
        this.counter = new TimeCounter(state.getTimeCounter());
        this.id = state.getId();
        this.age = state.getAge();
        this.universe3D = new BasicUniverse3D();
        this.environment = new BasicEnvironment(state.getEnvironment());
        this.trees = new HashSet<Tree>();
        Set treeStates = state.getTrees();
        for (TreeState treeState : treeStates) {
            this.trees.add(new BasicTree(this, treeState));
        }
        this.fallenLeaves = new HashSet<TreeLeaf>();
        Set fallenLeafStates = state.getFallenLeaves();
        for (TreeLeafState fallenLeafState : fallenLeafStates) {
            this.fallenLeaves.add(new BasicTreeLeaf(this, fallenLeafState));
        }
        this.universe3D.initFromUniverse((Universe)this);
    }

    public Long getId() {
        return this.id;
    }

    public int getAge() {
        return this.age;
    }

    public void spendTime() {
        this.counter.increment();
        ++this.age;
        for (LivingPart livingPart : this.getLivingParts()) {
            livingPart.spendTime();
        }
    }

    public Set<LivingPart> getLivingParts() {
        HashSet<Tree> livingParts = new HashSet<Tree>();
        livingParts.addAll(this.trees);
        return Collections.unmodifiableSet(livingParts);
    }

    public Set<Tree> getTrees() {
        return Collections.unmodifiableSet(this.trees);
    }

    public void addTree(Tree tree) {
        this.trees.add(tree);
    }

    public Set<TreeLeaf> getFallenLeaves() {
        return Collections.unmodifiableSet(this.fallenLeaves);
    }

    public void addFallenLeaf(TreeLeaf treeLeaf) {
        this.fallenLeaves.add(treeLeaf);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public TimeCounter getCounter() {
        return this.counter;
    }

    public UniverseState getState() {
        HashSet<TreeState> treeStates = new HashSet<TreeState>();
        for (Tree tree : this.trees) {
            treeStates.add(tree.getState());
        }
        HashSet<TreeLeafState> fallenLeafStates = new HashSet<TreeLeafState>();
        for (TreeLeaf fallenLeaf : this.fallenLeaves) {
            fallenLeafStates.add(fallenLeaf.getState());
        }
        return new UniverseState(this.id, this.age, treeStates, fallenLeafStates, this.environment.getState(), this.counter.getState());
    }

    public Universe3D getUniverse3D() {
        return this.universe3D;
    }

    public String toString() {
        return "BasicUniverse [environment=" + this.environment + ", id=" + this.id + ", age=" + this.age + ", trees=" + this.trees + ", fallenLeaves=" + this.fallenLeaves + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 + this.age;
        result = 31 * result + (this.trees == null ? 0 : ((Object)this.trees).hashCode());
        result = 31 * result + (this.fallenLeaves == null ? 0 : ((Object)this.fallenLeaves).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicUniverse other = (BasicUniverse)obj;
        if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.age != other.age) {
            return false;
        }
        if (this.trees == null ? other.trees != null : !((Object)this.trees).equals(other.trees)) {
            return false;
        }
        return !(this.fallenLeaves == null ? other.fallenLeaves != null : !((Object)this.fallenLeaves).equals(other.fallenLeaves));
    }
}

