/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.Percent;
import barsuift.simLife.PercentState;
import barsuift.simLife.j3d.tree.BasicTreeLeaf3D;
import barsuift.simLife.j3d.tree.TreeLeaf3D;
import barsuift.simLife.tree.LeafUpdateCode;
import barsuift.simLife.tree.TreeLeaf;
import barsuift.simLife.tree.TreeLeafState;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Observable;

public class BasicTreeLeaf
extends Observable
implements TreeLeaf {
    private static final Percent AGING_EFFICIENCY_DECREASE = new Percent(95);
    private static final Percent LOWEST_EFFICIENCY_BEFORE_FALLING = new Percent(10);
    private static final BigDecimal MAX_ENERGY_TO_COLLECT = new BigDecimal(150);
    private static final Percent ENERGY_RATIO_TO_KEEP = new Percent(66);
    private TreeLeafState state;
    private TreeLeaf3D leaf3D;
    private final Universe universe;

    public BasicTreeLeaf(Universe universe, TreeLeafState leafState) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (leafState == null) {
            throw new IllegalArgumentException("null leaf state");
        }
        this.universe = universe;
        this.state = new TreeLeafState(leafState);
        this.leaf3D = new BasicTreeLeaf3D(universe.getUniverse3D(), leafState.getLeaf3DState(), (TreeLeaf)this);
    }

    public Long getId() {
        return this.state.getId();
    }

    public void spendTime() {
        this.age();
        this.collectSolarEnergy();
        if (this.isTooWeak()) {
            this.fall();
        } else {
            this.useEnergy();
        }
    }

    private void age() {
        this.state.setAge(this.state.getAge() + 1);
        this.setChanged();
        this.notifyObservers(LeafUpdateCode.age);
        BigDecimal newEfficiency = this.getEfficiency().getValue().multiply(AGING_EFFICIENCY_DECREASE.getValue());
        this.state.setEfficiency(new PercentState(newEfficiency));
        this.setChanged();
        this.notifyObservers(LeafUpdateCode.efficiency);
    }

    private void collectSolarEnergy() {
        Percent lightRate = this.universe.getEnvironment().getSun().getLuminosity();
        BigDecimal solarEnergyRateCollected = this.getEfficiency().getValue().multiply(lightRate.getValue());
        BigDecimal energyCollected = solarEnergyRateCollected.multiply(MAX_ENERGY_TO_COLLECT).multiply(new BigDecimal(this.leaf3D.getArea()));
        BigDecimal energyCollectedForLeaf = energyCollected.multiply(ENERGY_RATIO_TO_KEEP.getValue());
        BigDecimal freeEnergyCollected = energyCollected.subtract(energyCollectedForLeaf);
        this.state.setEnergy(this.state.getEnergy().add(energyCollectedForLeaf));
        this.state.setFreeEnergy(this.state.getFreeEnergy().add(freeEnergyCollected));
        this.setChanged();
        this.notifyObservers(LeafUpdateCode.energy);
    }

    public boolean isTooWeak() {
        return this.getEfficiency().compareTo(LOWEST_EFFICIENCY_BEFORE_FALLING) < 0;
    }

    private void fall() {
        this.universe.addFallenLeaf((TreeLeaf)this);
        this.setChanged();
        this.notifyObservers(LeafUpdateCode.fall);
    }

    private void useEnergy() {
        this.improveEfficiency();
    }

    private void improveEfficiency() {
        BigDecimal maxEfficiencyToAdd = new BigDecimal(1).subtract(this.getEfficiency().getValue());
        BigDecimal efficiencyToAdd = maxEfficiencyToAdd.min(this.getEnergy().movePointLeft(2));
        this.state.setEfficiency(new PercentState(this.getEfficiency().getValue().add(efficiencyToAdd).setScale(10, RoundingMode.HALF_DOWN)));
        this.setChanged();
        this.notifyObservers(LeafUpdateCode.efficiency);
        this.state.setEnergy(this.getEnergy().subtract(efficiencyToAdd.movePointRight(2)).setScale(10, RoundingMode.HALF_DOWN));
        this.setChanged();
        this.notifyObservers(LeafUpdateCode.energy);
    }

    public Percent getEfficiency() {
        return this.state.getEfficiency().toPercent();
    }

    public BigDecimal getEnergy() {
        return this.state.getEnergy();
    }

    public BigDecimal collectFreeEnergy() {
        BigDecimal freeEnergy = this.state.getFreeEnergy();
        this.state.setFreeEnergy(new BigDecimal(0));
        return freeEnergy;
    }

    public int getAge() {
        return this.state.getAge();
    }

    public TreeLeaf3D getTreeLeaf3D() {
        return this.leaf3D;
    }

    public TreeLeafState getState() {
        this.state.setLeaf3DState(this.leaf3D.getState());
        return new TreeLeafState(this.state);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicTreeLeaf other = (BasicTreeLeaf)obj;
        return !(this.state == null ? other.state != null : !this.state.equals((Object)other.state));
    }

    public String toString() {
        return "BasicTreeLeaf [state=" + this.state + "]";
    }
}

