/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.Percent;
import barsuift.simLife.j3d.tree.BasicTreeBranch3D;
import barsuift.simLife.j3d.tree.TreeBranch3D;
import barsuift.simLife.tree.BasicTreeBranchPart;
import barsuift.simLife.tree.TreeBranch;
import barsuift.simLife.tree.TreeBranchPart;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicTreeBranch
implements TreeBranch {
    private static final Percent ENERGY_RATIO_TO_KEEP = new Percent(0);
    private final Long id;
    private List<TreeBranchPart> parts;
    private TreeBranch3D branch3D;
    private int age;
    private BigDecimal energy;
    private BigDecimal freeEnergy;

    public BasicTreeBranch(Universe universe, TreeBranchState branchState) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (branchState == null) {
            throw new IllegalArgumentException("null branch state");
        }
        this.id = branchState.getId();
        this.age = branchState.getAge();
        this.energy = branchState.getEnergy();
        this.freeEnergy = branchState.getFreeEnergy();
        List partStates = branchState.getBranchPartStates();
        this.parts = new ArrayList<TreeBranchPart>(partStates.size());
        for (TreeBranchPartState treeBranchPartState : partStates) {
            BasicTreeBranchPart branchPart = new BasicTreeBranchPart(universe, treeBranchPartState);
            this.parts.add(branchPart);
        }
        this.branch3D = new BasicTreeBranch3D(universe.getUniverse3D(), branchState.getBranch3DState(), (TreeBranch)this);
    }

    public Long getId() {
        return this.id;
    }

    public int getAge() {
        return this.age;
    }

    public void spendTime() {
        ++this.age;
        for (TreeBranchPart branchPart : this.parts) {
            branchPart.spendTime();
        }
        this.collectFreeEnergyFromParts();
    }

    private void collectFreeEnergyFromParts() {
        BigDecimal freeEnergyCollectedFromParts = new BigDecimal(0);
        for (TreeBranchPart part : this.parts) {
            freeEnergyCollectedFromParts = freeEnergyCollectedFromParts.add(part.collectFreeEnergy());
        }
        BigDecimal energyCollectedForBranch = freeEnergyCollectedFromParts.multiply(ENERGY_RATIO_TO_KEEP.getValue());
        BigDecimal freeEnergyCollected = freeEnergyCollectedFromParts.subtract(energyCollectedForBranch);
        this.energy = this.energy.add(energyCollectedForBranch);
        this.freeEnergy = this.freeEnergy.add(freeEnergyCollected);
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public BigDecimal collectFreeEnergy() {
        BigDecimal freeEnergy = this.freeEnergy;
        this.freeEnergy = new BigDecimal(0);
        return freeEnergy;
    }

    public int getNbLeaves() {
        int result = 0;
        for (TreeBranchPart branchPart : this.parts) {
            result += branchPart.getNbLeaves();
        }
        return result;
    }

    public List<TreeBranchPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    public int getNbParts() {
        return this.parts.size();
    }

    public TreeBranchState getState() {
        ArrayList<TreeBranchPartState> partStates = new ArrayList<TreeBranchPartState>(this.parts.size());
        for (TreeBranchPart branchPart : this.parts) {
            partStates.add(branchPart.getState());
        }
        return new TreeBranchState(this.id, this.age, this.energy, this.freeEnergy, partStates, this.branch3D.getState());
    }

    public TreeBranch3D getBranch3D() {
        return this.branch3D;
    }

    public String toString() {
        return "BasicTreeBranch [age=" + this.age + ", energy=" + this.energy + ", freeEnergy=" + this.freeEnergy + ", id=" + this.id + ", parts=" + this.parts + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.age;
        result = 31 * result + (this.energy == null ? 0 : this.energy.hashCode());
        result = 31 * result + (this.freeEnergy == null ? 0 : this.freeEnergy.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.parts == null ? 0 : ((Object)this.parts).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicTreeBranch other = (BasicTreeBranch)obj;
        if (this.age != other.age) {
            return false;
        }
        if (this.energy == null ? other.energy != null : !this.energy.equals(other.energy)) {
            return false;
        }
        if (this.freeEnergy == null ? other.freeEnergy != null : !this.freeEnergy.equals(other.freeEnergy)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.parts == null ? other.parts != null : !((Object)this.parts).equals(other.parts));
    }
}

