/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.tree.BasicTree3D;
import barsuift.simLife.j3d.tree.Tree3D;
import barsuift.simLife.tree.BasicTreeBranch;
import barsuift.simLife.tree.BasicTreeTrunk;
import barsuift.simLife.tree.Tree;
import barsuift.simLife.tree.TreeBranch;
import barsuift.simLife.tree.TreeBranchState;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.tree.TreeTrunk;
import barsuift.simLife.universe.Universe;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class BasicTree
implements Tree {
    private final Long id;
    private int age;
    private BigDecimal energy;
    private List<TreeBranch> branches;
    private TreeTrunk trunk;
    private float height;
    private Tree3D tree3D;

    public BasicTree(Universe universe, TreeState state) {
        if (universe == null) {
            throw new IllegalArgumentException("null universe");
        }
        if (state == null) {
            throw new IllegalArgumentException("null tree state");
        }
        this.id = state.getId();
        this.age = state.getAge();
        this.energy = state.getEnergy();
        this.height = state.getHeight();
        List branchStates = state.getBranches();
        this.branches = new ArrayList<TreeBranch>(branchStates.size());
        for (TreeBranchState treeBranchState : branchStates) {
            this.branches.add(new BasicTreeBranch(universe, treeBranchState));
        }
        this.trunk = new BasicTreeTrunk(universe, state.getTrunkState());
        this.tree3D = new BasicTree3D(universe.getUniverse3D(), state.getTree3DState(), (Tree)this);
    }

    public Long getId() {
        return this.id;
    }

    public int getAge() {
        return this.age;
    }

    public void spendTime() {
        ++this.age;
        this.trunk.spendTime();
        for (TreeBranch branch : this.branches) {
            branch.spendTime();
        }
        this.collectFreeEnergyFromBranches();
    }

    private void collectFreeEnergyFromBranches() {
        BigDecimal freeEnergyCollectedFromBranches = new BigDecimal(0);
        for (TreeBranch branch : this.branches) {
            freeEnergyCollectedFromBranches = freeEnergyCollectedFromBranches.add(branch.collectFreeEnergy());
        }
        this.energy = this.energy.add(freeEnergyCollectedFromBranches);
    }

    public float getHeight() {
        return this.height;
    }

    public int getNbBranches() {
        return this.branches.size();
    }

    public BigDecimal getEnergy() {
        return this.energy;
    }

    public int getNbLeaves() {
        int result = 0;
        for (TreeBranch branch : this.branches) {
            result += branch.getNbLeaves();
        }
        return result;
    }

    public List<TreeBranch> getBranches() {
        return this.branches;
    }

    public TreeState getState() {
        ArrayList<TreeBranchState> branchStates = new ArrayList<TreeBranchState>();
        for (TreeBranch treeBranch : this.branches) {
            branchStates.add(treeBranch.getState());
        }
        return new TreeState(this.id, this.age, this.energy, branchStates, this.trunk.getState(), this.height, this.tree3D.getState());
    }

    public Tree3D getTree3D() {
        return this.tree3D;
    }

    public TreeTrunk getTrunk() {
        return this.trunk;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.age;
        result = 31 * result + (this.branches == null ? 0 : ((Object)this.branches).hashCode());
        result = 31 * result + (this.energy == null ? 0 : this.energy.hashCode());
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.trunk == null ? 0 : this.trunk.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicTree other = (BasicTree)obj;
        if (this.age != other.age) {
            return false;
        }
        if (this.branches == null ? other.branches != null : !((Object)this.branches).equals(other.branches)) {
            return false;
        }
        if (this.energy == null ? other.energy != null : !this.energy.equals(other.energy)) {
            return false;
        }
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.trunk == null ? other.trunk != null : !this.trunk.equals(other.trunk));
    }

    public String toString() {
        return "BasicTree [age=" + this.age + ", branches=" + this.branches + ", energy=" + this.energy + ", height=" + this.height + ", id=" + this.id + ", trunk=" + this.trunk + "]";
    }
}

