/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.FileTestHelper;
import barsuift.simLife.universe.BasicUniverseFactory;
import barsuift.simLife.universe.BasicUniverseIO;
import barsuift.simLife.universe.Universe;
import java.io.File;
import junit.framework.TestCase;

public class BasicUniverseIOTest
extends TestCase {
    private BasicUniverseIO universeIo;
    private File file;

    protected void setUp() throws Exception {
        super.setUp();
        this.file = new File("target/test-data/universe.xml");
        FileTestHelper.deleteAllFiles((File)this.file.getParentFile());
        this.universeIo = new BasicUniverseIO(this.file);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.universeIo = null;
        FileTestHelper.deleteAllFiles((File)this.file.getParentFile());
        this.file = null;
    }

    public void testWriteAndReadRandom() throws Exception {
        BasicUniverseFactory factory = new BasicUniverseFactory();
        Universe universe = factory.createRandom();
        this.universeIo.write(universe);
        Universe universe2 = this.universeIo.read();
        BasicUniverseIOTest.assertEquals((Object)universe, (Object)universe2);
    }

    public void testWriteAndReadEmpty() throws Exception {
        BasicUniverseFactory factory = new BasicUniverseFactory();
        Universe universe = factory.createEmpty();
        this.universeIo.write(universe);
        Universe universe2 = this.universeIo.read();
        BasicUniverseIOTest.assertEquals((Object)universe, (Object)universe2);
    }
}

