/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.tree.BasicTreeTrunk;
import barsuift.simLife.tree.TreeTrunkState;
import barsuift.simLife.tree.TreeTrunkStateFactory;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import junit.framework.TestCase;

public class BasicTreeTrunkTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasicTreeTrunk() {
        try {
            new BasicTreeTrunk((Universe)new MockUniverse(), null);
            BasicTreeTrunkTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTreeTrunk(null, new TreeTrunkState());
            BasicTreeTrunkTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        TreeTrunkStateFactory factory = new TreeTrunkStateFactory();
        float radius = 4.2f;
        float height = 6.8f;
        TreeTrunkState trunkState = factory.createRandomTreeTrunkState(radius, height);
        BasicTreeTrunk treeTrunk = new BasicTreeTrunk((Universe)new MockUniverse(), trunkState);
        BasicTreeTrunkTest.assertEquals((Object)Float.valueOf(height), (Object)Float.valueOf(treeTrunk.getHeight()));
        BasicTreeTrunkTest.assertEquals((Object)Float.valueOf(radius), (Object)Float.valueOf(treeTrunk.getRadius()));
        BasicTreeTrunkTest.assertEquals((Object)trunkState, (Object)treeTrunk.getState());
    }

    public void testSpendTime() {
        TreeTrunkState trunkState = new TreeTrunkState();
        trunkState.setAge(12);
        BasicTreeTrunk treeTrunk = new BasicTreeTrunk((Universe)new MockUniverse(), trunkState);
        treeTrunk.spendTime();
        BasicTreeTrunkTest.assertEquals((int)13, (int)treeTrunk.getAge());
    }
}

