/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.environment;

import barsuift.simLife.Percent;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.environment.SunState;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.j3d.universe.environment.BasicSun3D;
import barsuift.simLife.j3d.universe.environment.Sun3D;
import java.util.Observable;

public class BasicSun
extends Observable
implements Sun {
    private Percent luminosity;
    private Percent riseAngle;
    private Percent zenithAngle;
    private final Sun3D sun3D;

    public BasicSun(SunState state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("Null sun state");
        }
        this.luminosity = new Percent(state.getLuminosity());
        this.riseAngle = new Percent(state.getRiseAngle());
        this.zenithAngle = new Percent(state.getZenithAngle());
        this.sun3D = new BasicSun3D((Sun)this);
    }

    public Percent getLuminosity() {
        return this.luminosity;
    }

    public void setLuminosity(Percent luminosity) throws IllegalArgumentException {
        if (luminosity == null) {
            throw new IllegalArgumentException("Sun luminosity can not be null");
        }
        if (!this.luminosity.equals((Object)luminosity)) {
            this.luminosity = luminosity;
            this.setChanged();
            this.notifyObservers(SunUpdateCode.luminosity);
        }
    }

    public Percent getRiseAngle() {
        return this.riseAngle;
    }

    public void setRiseAngle(Percent riseAngle) {
        if (riseAngle == null) {
            throw new IllegalArgumentException("Sun rise angle can not be null");
        }
        if (!this.riseAngle.equals((Object)riseAngle)) {
            this.riseAngle = riseAngle;
            this.setChanged();
            this.notifyObservers(SunUpdateCode.riseAngle);
        }
    }

    public Percent getZenithAngle() {
        return this.zenithAngle;
    }

    public void setZenithAngle(Percent zenithAngle) {
        if (zenithAngle == null) {
            throw new IllegalArgumentException("Sun zenith angle can not be null");
        }
        if (!this.zenithAngle.equals((Object)zenithAngle)) {
            this.zenithAngle = zenithAngle;
            this.setChanged();
            this.notifyObservers(SunUpdateCode.zenithAngle);
        }
    }

    public SunState getState() {
        return new SunState(this.luminosity.getState(), this.riseAngle.getState(), this.zenithAngle.getState());
    }

    public Sun3D getSun3D() {
        return this.sun3D;
    }

    public String toString() {
        return "BasicSun [luminosity=" + this.luminosity + ", riseAngle=" + this.riseAngle + ", zenithAngle=" + this.zenithAngle + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.luminosity == null ? 0 : this.luminosity.hashCode());
        result = 31 * result + (this.riseAngle == null ? 0 : this.riseAngle.hashCode());
        result = 31 * result + (this.zenithAngle == null ? 0 : this.zenithAngle.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSun other = (BasicSun)obj;
        if (this.luminosity == null ? other.luminosity != null : !this.luminosity.equals((Object)other.luminosity)) {
            return false;
        }
        if (this.riseAngle == null ? other.riseAngle != null : !this.riseAngle.equals((Object)other.riseAngle)) {
            return false;
        }
        return !(this.zenithAngle == null ? other.zenithAngle != null : !this.zenithAngle.equals((Object)other.zenithAngle));
    }
}

